/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.types.AbstractValueType;
import org.seasar.extension.jdbc.util.BindVariableUtil;
import org.seasar.framework.exception.SSQLException;
import org.seasar.framework.util.InputStreamUtil;

public class BytesType
extends AbstractValueType {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final Trait BYTES_TRAIT = new BytesTrait();
    public static final Trait STREAM_TRAIT = new StreamTrait();
    public static final Trait BLOB_TRAIT = new BlobTrait();
    protected Trait trait;

    public BytesType(Trait trait) {
        super(trait.getSqlType());
        this.trait = trait;
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else if (value instanceof byte[]) {
            this.trait.set(ps, index, (byte[])value);
        } else {
            ps.setObject(index, value);
        }
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else if (value instanceof byte[]) {
            this.trait.set(cs, parameterName, (byte[])value);
        } else {
            cs.setObject(parameterName, value);
        }
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return this.trait.get(resultSet, index);
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return this.trait.get(resultSet, columnName);
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return this.trait.get(cs, index);
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return this.trait.get(cs, parameterName);
    }

    public String toText(Object value) {
        if (value == null) {
            return BindVariableUtil.nullText();
        }
        if (value instanceof byte[]) {
            return BindVariableUtil.toText((byte[])value);
        }
        return BindVariableUtil.toText(value);
    }

    public static byte[] toBytes(InputStream is) throws SQLException {
        try {
            byte[] bytes = new byte[is.available()];
            is.read(bytes);
            return bytes;
        }
        catch (IOException e) {
            throw new SSQLException("ESSR0040", new Object[]{e.getMessage()});
        }
    }

    public static byte[] toBytes(Blob blob) throws SQLException {
        if (blob == null) {
            return null;
        }
        long length = blob.length();
        if (length == 0L) {
            return EMPTY_BYTES;
        }
        if (length > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return blob.getBytes(1L, (int)length);
    }

    public static class BlobTrait
    implements Trait {
        public int getSqlType() {
            return 2004;
        }

        public void set(PreparedStatement ps, int parameterIndex, byte[] bytes) throws SQLException {
            ps.setBinaryStream(parameterIndex, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
        }

        public void set(CallableStatement cs, String parameterName, byte[] bytes) throws SQLException {
            cs.setBinaryStream(parameterName, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
        }

        public byte[] get(ResultSet rs, int columnIndex) throws SQLException {
            return BytesType.toBytes(rs.getBlob(columnIndex));
        }

        public byte[] get(ResultSet rs, String columnName) throws SQLException {
            return BytesType.toBytes(rs.getBlob(columnName));
        }

        public byte[] get(CallableStatement cs, int columnIndex) throws SQLException {
            return BytesType.toBytes(cs.getBlob(columnIndex));
        }

        public byte[] get(CallableStatement cs, String columnName) throws SQLException {
            return BytesType.toBytes(cs.getBlob(columnName));
        }
    }

    public static class StreamTrait
    implements Trait {
        public int getSqlType() {
            return -2;
        }

        public void set(PreparedStatement ps, int parameterIndex, byte[] bytes) throws SQLException {
            ps.setBinaryStream(parameterIndex, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
        }

        public void set(CallableStatement cs, String parameterName, byte[] bytes) throws SQLException {
            cs.setBinaryStream(parameterName, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] get(ResultSet rs, int columnIndex) throws SQLException {
            InputStream is = rs.getBinaryStream(columnIndex);
            try {
                byte[] byArray = BytesType.toBytes(is);
                return byArray;
            }
            finally {
                InputStreamUtil.close((InputStream)is);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] get(ResultSet rs, String columnName) throws SQLException {
            InputStream is = rs.getBinaryStream(columnName);
            try {
                byte[] byArray = BytesType.toBytes(is);
                return byArray;
            }
            finally {
                InputStreamUtil.close((InputStream)is);
            }
        }

        public byte[] get(CallableStatement cs, int columnIndex) throws SQLException {
            return cs.getBytes(columnIndex);
        }

        public byte[] get(CallableStatement cs, String columnName) throws SQLException {
            return cs.getBytes(columnName);
        }
    }

    public static class BytesTrait
    implements Trait {
        public int getSqlType() {
            return -2;
        }

        public void set(PreparedStatement ps, int parameterIndex, byte[] bytes) throws SQLException {
            ps.setBytes(parameterIndex, bytes);
        }

        public void set(CallableStatement cs, String parameterName, byte[] bytes) throws SQLException {
            cs.setBytes(parameterName, bytes);
        }

        public byte[] get(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getBytes(columnIndex);
        }

        public byte[] get(ResultSet rs, String columnName) throws SQLException {
            return rs.getBytes(columnName);
        }

        public byte[] get(CallableStatement cs, int columnIndex) throws SQLException {
            return cs.getBytes(columnIndex);
        }

        public byte[] get(CallableStatement cs, String columnName) throws SQLException {
            return cs.getBytes(columnName);
        }
    }

    public static interface Trait {
        public int getSqlType();

        public void set(PreparedStatement var1, int var2, byte[] var3) throws SQLException;

        public void set(CallableStatement var1, String var2, byte[] var3) throws SQLException;

        public byte[] get(ResultSet var1, int var2) throws SQLException;

        public byte[] get(ResultSet var1, String var2) throws SQLException;

        public byte[] get(CallableStatement var1, int var2) throws SQLException;

        public byte[] get(CallableStatement var1, String var2) throws SQLException;
    }
}

