/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.tags;

import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.DynamicAttributes;
import org.seasar.cubby.controller.FormWrapper;
import org.seasar.cubby.controller.FormWrapperFactory;
import org.seasar.cubby.tags.LinkSupport;
import org.seasar.cubby.tags.ParamParent;
import org.seasar.cubby.tags.TagUtils;
import org.seasar.cubby.util.LinkBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormTag
extends BodyTagSupport
implements DynamicAttributes,
ParamParent {
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> dynamicAttributes = new HashMap<String, Object>();
    private Object value;
    private boolean encodeURL = true;
    private final LinkSupport linkSupport = new LinkSupport();
    private final LinkBuilder linkBuilder = new LinkBuilder();
    private transient FormWrapper formWrapper;

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        this.dynamicAttributes.put(localName, value);
    }

    protected Map<String, Object> getDynamicAttribute() {
        return this.dynamicAttributes;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setActionClass(String actionClass) {
        this.linkSupport.setActionClassName(actionClass);
    }

    public void setActionMethod(String actionMethod) {
        this.linkSupport.setActionMethodName(actionMethod);
    }

    public void setEncodeURL(boolean encodeURL) {
        this.encodeURL = encodeURL;
    }

    public void setProtocol(String protocol) {
        this.linkBuilder.setProtocol(protocol);
    }

    public void setPort(int port) {
        this.linkBuilder.setPort(port);
    }

    @Override
    public void addParameter(String name, String value) {
        this.linkSupport.addParameter(name, value);
    }

    public int doStartTag() throws JspException {
        FormWrapperFactory formWrapperFactory = (FormWrapperFactory)this.pageContext.findAttribute("org.seasar.cubby.formWrapperFactory");
        this.formWrapper = formWrapperFactory.create(this.value);
        return 2;
    }

    public int doEndTag() throws JspException {
        String contextPath = TagUtils.getContextPath((JspContext)this.pageContext);
        if (this.linkSupport.isLinkable()) {
            String characterEncoding = this.pageContext.getRequest().getCharacterEncoding();
            String url = contextPath + this.linkSupport.getPath(characterEncoding);
            this.dynamicAttributes.put("action", url);
        }
        if (this.encodeURL && this.dynamicAttributes.containsKey("action")) {
            String url;
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
            String actionPath = (String)this.dynamicAttributes.get("action");
            try {
                url = this.linkBuilder.file(actionPath).toLink(request);
            }
            catch (MalformedURLException e) {
                throw new JspException((Throwable)e);
            }
            String encodedUrl = response.encodeURL(url);
            this.dynamicAttributes.put("action", encodedUrl);
        }
        JspWriter out = this.pageContext.getOut();
        try {
            out.write("<form ");
            out.write(TagUtils.toAttr(this.getDynamicAttribute()));
            out.write(">");
            BodyContent bodyContent = this.getBodyContent();
            if (bodyContent != null) {
                bodyContent.writeOut((Writer)out);
            }
            out.write("</form>");
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        this.reset();
        return 6;
    }

    private void reset() {
        this.linkSupport.clear();
        this.linkBuilder.clear();
        this.dynamicAttributes.clear();
        this.value = null;
        this.formWrapper = null;
    }

    public FormWrapper getFormWrapper() {
        return this.formWrapper;
    }
}

