/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public abstract class TypeBinding
extends Binding {
    public int id = Integer.MAX_VALUE;
    public long tagBits = 0L;
    public static final BaseTypeBinding INT = new BaseTypeBinding(10, TypeConstants.INT, new char[]{'I'});
    public static final BaseTypeBinding BYTE = new BaseTypeBinding(3, TypeConstants.BYTE, new char[]{'B'});
    public static final BaseTypeBinding SHORT = new BaseTypeBinding(4, TypeConstants.SHORT, new char[]{'S'});
    public static final BaseTypeBinding CHAR = new BaseTypeBinding(2, TypeConstants.CHAR, new char[]{'C'});
    public static final BaseTypeBinding LONG = new BaseTypeBinding(7, TypeConstants.LONG, new char[]{'J'});
    public static final BaseTypeBinding FLOAT = new BaseTypeBinding(9, TypeConstants.FLOAT, new char[]{'F'});
    public static final BaseTypeBinding DOUBLE = new BaseTypeBinding(8, TypeConstants.DOUBLE, new char[]{'D'});
    public static final BaseTypeBinding BOOLEAN = new BaseTypeBinding(5, TypeConstants.BOOLEAN, new char[]{'Z'});
    public static final BaseTypeBinding NULL = new BaseTypeBinding(12, TypeConstants.NULL, new char[]{'N'});
    public static final BaseTypeBinding VOID = new BaseTypeBinding(6, TypeConstants.VOID, new char[]{'V'});

    public static final TypeBinding wellKnownType(Scope scope, int id) {
        switch (id) {
            case 5: {
                return BOOLEAN;
            }
            case 3: {
                return BYTE;
            }
            case 2: {
                return CHAR;
            }
            case 4: {
                return SHORT;
            }
            case 8: {
                return DOUBLE;
            }
            case 9: {
                return FLOAT;
            }
            case 10: {
                return INT;
            }
            case 7: {
                return LONG;
            }
            case 1: {
                return scope.getJavaLangObject();
            }
            case 11: {
                return scope.getJavaLangString();
            }
        }
        return null;
    }

    public boolean canBeInstantiated() {
        return !this.isBaseType();
    }

    public TypeBinding capture(Scope scope, int position) {
        return this;
    }

    public void collectSubstitutes(Scope scope, TypeBinding actualType, InferenceContext inferenceContext, int constraint) {
    }

    public abstract char[] constantPoolName();

    public String debugName() {
        return new String(this.readableName());
    }

    public int dimensions() {
        return 0;
    }

    public ReferenceBinding enclosingType() {
        return null;
    }

    public TypeBinding erasure() {
        return this;
    }

    public ReferenceBinding findSuperTypeErasingTo(int wellKnownErasureID, boolean erasureIsClass) {
        if (!(this instanceof ReferenceBinding)) {
            return null;
        }
        ReferenceBinding reference = (ReferenceBinding)this;
        if (reference.id == wellKnownErasureID || !this.isTypeVariable() && !this.isIntersectionType() && this.erasure().id == wellKnownErasureID) {
            return reference;
        }
        ReferenceBinding currentType = reference;
        if (erasureIsClass) {
            while ((currentType = currentType.superclass()) != null) {
                if (currentType.id != wellKnownErasureID && (currentType.isTypeVariable() || currentType.isIntersectionType() || currentType.erasure().id != wellKnownErasureID)) continue;
                return currentType;
            }
            return null;
        }
        ReferenceBinding[] interfacesToVisit = null;
        int nextPosition = 0;
        do {
            ReferenceBinding[] itsInterfaces;
            if ((itsInterfaces = currentType.superInterfaces()) == null || itsInterfaces == Binding.NO_SUPERINTERFACES) continue;
            if (interfacesToVisit == null) {
                interfacesToVisit = itsInterfaces;
                nextPosition = interfacesToVisit.length;
                continue;
            }
            int itsLength = itsInterfaces.length;
            if (nextPosition + itsLength >= interfacesToVisit.length) {
                ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
            }
            int a = 0;
            while (a < itsLength) {
                block17: {
                    ReferenceBinding next = itsInterfaces[a];
                    int b = 0;
                    while (b < nextPosition) {
                        if (next != interfacesToVisit[b]) {
                            ++b;
                            continue;
                        }
                        break block17;
                    }
                    interfacesToVisit[nextPosition++] = next;
                }
                ++a;
            }
        } while ((currentType = currentType.superclass()) != null);
        int i = 0;
        while (i < nextPosition) {
            currentType = interfacesToVisit[i];
            if (currentType.id == wellKnownErasureID || !currentType.isTypeVariable() && !currentType.isIntersectionType() && currentType.erasure().id == wellKnownErasureID) {
                return currentType;
            }
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces != null && itsInterfaces != Binding.NO_SUPERINTERFACES) {
                int itsLength = itsInterfaces.length;
                if (nextPosition + itsLength >= interfacesToVisit.length) {
                    ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                }
                int a = 0;
                while (a < itsLength) {
                    block18: {
                        ReferenceBinding next = itsInterfaces[a];
                        int b = 0;
                        while (b < nextPosition) {
                            if (next != interfacesToVisit[b]) {
                                ++b;
                                continue;
                            }
                            break block18;
                        }
                        interfacesToVisit[nextPosition++] = next;
                    }
                    ++a;
                }
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public TypeBinding findSuperTypeWithSameErasure(TypeBinding otherType) {
        if (this == otherType) {
            return this;
        }
        if (otherType == null) {
            return null;
        }
        switch (this.kind()) {
            case 68: {
                arrayType = (ArrayBinding)this;
                otherDim = otherType.dimensions();
                if (arrayType.dimensions != otherDim) {
                    switch (otherType.id) {
                        case 1: 
                        case 36: 
                        case 37: {
                            return otherType;
                        }
                    }
                    if (otherDim < arrayType.dimensions && otherType.leafComponentType().id == 1) {
                        return otherType;
                    }
                    return null;
                }
                if (!(arrayType.leafComponentType instanceof ReferenceBinding)) {
                    return null;
                }
                leafSuperType = arrayType.leafComponentType.findSuperTypeWithSameErasure(otherType.leafComponentType());
                if (leafSuperType == null) {
                    return null;
                }
                return arrayType.environment().createArrayType(leafSuperType, arrayType.dimensions);
            }
            case 4100: {
                if (this.isCapture()) {
                    capture = (CaptureBinding)this;
                    captureBound = capture.firstBound;
                    if (captureBound instanceof ArrayBinding && (match = captureBound.findSuperTypeWithSameErasure(otherType)) != null) {
                        return match;
                    }
                }
            }
            case 4: 
            case 260: 
            case 516: 
            case 1028: 
            case 2052: {
                if (!otherType.isTypeVariable() && !otherType.isIntersectionType()) {
                    otherType = otherType.erasure();
                }
                if (this == otherType || !this.isTypeVariable() && !this.isIntersectionType() && this.erasure() == otherType) {
                    return this;
                }
                currentType = (ReferenceBinding)this;
                if (!otherType.isInterface()) {
                    while ((currentType = currentType.superclass()) != null) {
                        if (currentType != otherType && (currentType.isTypeVariable() || currentType.isIntersectionType() || currentType.erasure() != otherType)) continue;
                        return currentType;
                    }
                    return null;
                }
                interfacesToVisit = null;
                nextPosition = 0;
                do {
                    if ((itsInterfaces = currentType.superInterfaces()) == Binding.NO_SUPERINTERFACES) continue;
                    if (interfacesToVisit == null) {
                        interfacesToVisit = itsInterfaces;
                        nextPosition = interfacesToVisit.length;
                        continue;
                    }
                    itsLength = itsInterfaces.length;
                    if (nextPosition + itsLength >= interfacesToVisit.length) {
                        v0 = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                        System.arraycopy(v0, 0, interfacesToVisit, 0, nextPosition);
                    }
                    a = 0;
                    while (a < itsLength) {
                        next = itsInterfaces[a];
                        b = 0;
                        while (b < nextPosition) {
                            if (next != interfacesToVisit[b]) {
                                ++b;
                                continue;
                            }
                            ** GOTO lbl62
                        }
                        interfacesToVisit[nextPosition++] = next;
lbl62:
                        // 2 sources

                        ++a;
                    }
                } while ((currentType = currentType.superclass()) != null);
                i = 0;
                while (i < nextPosition) {
                    currentType = interfacesToVisit[i];
                    if (currentType == otherType || !currentType.isTypeVariable() && !currentType.isIntersectionType() && currentType.erasure() == otherType) {
                        return currentType;
                    }
                    itsInterfaces = currentType.superInterfaces();
                    if (itsInterfaces == Binding.NO_SUPERINTERFACES) ** GOTO lbl89
                    itsLength = itsInterfaces.length;
                    if (nextPosition + itsLength >= interfacesToVisit.length) {
                        v1 = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                        System.arraycopy(v1, 0, interfacesToVisit, 0, nextPosition);
                    }
                    a = 0;
                    while (a < itsLength) {
                        next = itsInterfaces[a];
                        b = 0;
                        while (b < nextPosition) {
                            if (next != interfacesToVisit[b]) {
                                ++b;
                                continue;
                            }
                            ** GOTO lbl87
                        }
                        interfacesToVisit[nextPosition++] = next;
lbl87:
                        // 2 sources

                        ++a;
                    }
lbl89:
                    // 2 sources

                    ++i;
                }
                break;
            }
        }
        return null;
    }

    public TypeBinding genericCast(TypeBinding otherType) {
        if (this == otherType) {
            return null;
        }
        TypeBinding otherErasure = otherType.erasure();
        if (otherErasure == this.erasure()) {
            return null;
        }
        return otherErasure;
    }

    public char[] genericTypeSignature() {
        return this.signature();
    }

    public abstract PackageBinding getPackage();

    public boolean isAnnotationType() {
        return false;
    }

    public final boolean isAnonymousType() {
        return (this.tagBits & 0x20L) != 0L;
    }

    public final boolean isArrayType() {
        return (this.tagBits & 1L) != 0L;
    }

    public final boolean isBaseType() {
        return (this.tagBits & 2L) != 0L;
    }

    public boolean isBoundParameterizedType() {
        return (this.tagBits & 0x800000L) != 0L;
    }

    public boolean isCapture() {
        return false;
    }

    public boolean isClass() {
        return false;
    }

    public abstract boolean isCompatibleWith(TypeBinding var1);

    public boolean isEnum() {
        return false;
    }

    public boolean isEquivalentTo(TypeBinding otherType) {
        if (this == otherType) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        if (otherType.isWildcard()) {
            return ((WildcardBinding)otherType).boundCheck(this);
        }
        return false;
    }

    public boolean isGenericType() {
        return false;
    }

    public final boolean isHierarchyInconsistent() {
        return (this.tagBits & 0x20000L) != 0L;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isIntersectingWith(TypeBinding otherType) {
        return this == otherType;
    }

    public boolean isIntersectionType() {
        return false;
    }

    public final boolean isLocalType() {
        return (this.tagBits & 0x10L) != 0L;
    }

    public final boolean isMemberType() {
        return (this.tagBits & 8L) != 0L;
    }

    public final boolean isNestedType() {
        return (this.tagBits & 4L) != 0L;
    }

    public final boolean isNumericType() {
        switch (this.id) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean isParameterizedType() {
        return false;
    }

    public boolean isParameterizedWithOwnVariables() {
        if (this.kind() != 260) {
            return false;
        }
        ParameterizedTypeBinding paramType = (ParameterizedTypeBinding)this;
        if (paramType.arguments == null) {
            return false;
        }
        TypeVariableBinding[] variables = this.erasure().typeVariables();
        int i = 0;
        int length = variables.length;
        while (i < length) {
            if (variables[i] != paramType.arguments[i]) {
                return false;
            }
            ++i;
        }
        ReferenceBinding enclosing = paramType.enclosingType();
        return enclosing == null || !enclosing.erasure().isGenericType() || enclosing.isParameterizedWithOwnVariables();
    }

    public boolean isProvablyDistinctFrom(TypeBinding otherType, int depth) {
        if (this == otherType) {
            return false;
        }
        if (depth > 1) {
            return true;
        }
        switch (otherType.kind()) {
            case 516: 
            case 4100: {
                return false;
            }
        }
        switch (this.kind()) {
            case 516: 
            case 4100: {
                return false;
            }
            case 260: {
                ParameterizedTypeBinding parameterizedType = (ParameterizedTypeBinding)this;
                if (parameterizedType.genericType().isProvablyDistinctFrom(otherType.erasure(), depth)) {
                    return true;
                }
                switch (otherType.kind()) {
                    case 1028: 
                    case 2052: {
                        return false;
                    }
                    case 260: {
                        TypeBinding[] arguments = parameterizedType.arguments;
                        if (arguments == null) {
                            return false;
                        }
                        ParameterizedTypeBinding otherParameterizedType = (ParameterizedTypeBinding)otherType;
                        TypeBinding[] otherArguments = otherParameterizedType.arguments;
                        if (otherArguments == null) {
                            return false;
                        }
                        int i = 0;
                        int length = arguments.length;
                        while (i < length) {
                            if (arguments[i].isProvablyDistinctFrom(otherArguments[i], depth + 1)) {
                                return true;
                            }
                            ++i;
                        }
                        return false;
                    }
                }
                break;
            }
            case 1028: {
                if (depth > 0) {
                    return true;
                }
                return this.erasure().isProvablyDistinctFrom(otherType.erasure(), 0);
            }
            case 2052: {
                if (depth > 0) {
                    return true;
                }
                return this != otherType.erasure();
            }
        }
        return this != otherType;
    }

    public boolean isRawType() {
        return false;
    }

    public boolean isReifiable() {
        TypeBinding leafType = this.leafComponentType();
        if (!(leafType instanceof ReferenceBinding)) {
            return true;
        }
        ReferenceBinding current = (ReferenceBinding)leafType;
        do {
            switch (current.kind()) {
                case 516: 
                case 2052: 
                case 4100: {
                    return false;
                }
                case 260: {
                    if (!current.isBoundParameterizedType()) break;
                    return false;
                }
                case 1028: {
                    return true;
                }
            }
            if (current.isStatic()) {
                return true;
            }
            if (!current.isLocalType()) continue;
            NestedTypeBinding nestedType = (NestedTypeBinding)current.erasure();
            if (!nestedType.scope.methodScope().isStatic) continue;
            return true;
        } while ((current = current.enclosingType()) != null);
        return true;
    }

    public boolean isThrowable() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public boolean isTypeArgumentContainedBy(TypeBinding otherType) {
        if (this == otherType) {
            return true;
        }
        switch (otherType.kind()) {
            case 516: {
                TypeBinding lowerBound = this;
                TypeBinding upperBound = this;
                switch (this.kind()) {
                    case 516: {
                        WildcardBinding wildcard = (WildcardBinding)this;
                        switch (wildcard.boundKind) {
                            case 1: {
                                if (wildcard.otherBounds != null) break;
                                upperBound = wildcard.bound;
                                lowerBound = null;
                                break;
                            }
                            case 2: {
                                upperBound = wildcard;
                                lowerBound = wildcard.bound;
                                break;
                            }
                            case 0: {
                                upperBound = wildcard;
                                lowerBound = null;
                            }
                        }
                        break;
                    }
                    case 4100: {
                        if (!this.isCapture()) break;
                        CaptureBinding capture = (CaptureBinding)this;
                        if (capture.lowerBound == null) break;
                        lowerBound = capture.lowerBound;
                        break;
                    }
                }
                WildcardBinding otherWildcard = (WildcardBinding)otherType;
                if (otherWildcard.otherBounds != null) {
                    return false;
                }
                TypeBinding otherBound = otherWildcard.bound;
                switch (otherWildcard.boundKind) {
                    case 1: {
                        if (otherBound == this) {
                            return true;
                        }
                        if (upperBound == null) {
                            return false;
                        }
                        TypeBinding match = upperBound.findSuperTypeWithSameErasure(otherBound);
                        if (match == null) return upperBound.isCompatibleWith(otherBound);
                        if (!(match = match.leafComponentType()).isRawType()) return upperBound.isCompatibleWith(otherBound);
                        if (match != otherBound.leafComponentType()) return false;
                        return true;
                    }
                    case 2: {
                        if (otherBound == this) {
                            return true;
                        }
                        if (lowerBound == null) {
                            return false;
                        }
                        TypeBinding match = otherBound.findSuperTypeWithSameErasure(lowerBound);
                        if (match == null) return otherBound.isCompatibleWith(lowerBound);
                        if (!(match = match.leafComponentType()).isRawType()) return otherBound.isCompatibleWith(lowerBound);
                        if (match != lowerBound.leafComponentType()) return false;
                        return true;
                    }
                }
                return true;
            }
            case 260: {
                int otherLength;
                ReferenceBinding enclosing;
                if (!this.isParameterizedType()) {
                    return false;
                }
                ParameterizedTypeBinding paramType = (ParameterizedTypeBinding)this;
                ParameterizedTypeBinding otherParamType = (ParameterizedTypeBinding)otherType;
                if (paramType.actualType() != otherParamType.actualType()) {
                    return false;
                }
                if (!paramType.isStatic() && (enclosing = this.enclosingType()) != null) {
                    ReferenceBinding otherEnclosing = otherParamType.enclosingType();
                    if (otherEnclosing == null) {
                        return false;
                    }
                    if ((otherEnclosing.tagBits & 0x40000000L) == 0L ? enclosing != otherEnclosing : !enclosing.isEquivalentTo(otherParamType.enclosingType())) {
                        return false;
                    }
                }
                int length = paramType.arguments == null ? 0 : paramType.arguments.length;
                TypeBinding[] otherArguments = otherParamType.arguments;
                int n = otherLength = otherArguments == null ? 0 : otherArguments.length;
                if (otherLength != length) {
                    return false;
                }
                int i = 0;
                while (i < length) {
                    TypeBinding argument = paramType.arguments[i];
                    TypeBinding otherArgument = otherArguments[i];
                    if (argument != otherArgument) {
                        int kind = argument.kind();
                        if (otherArgument.kind() != kind) {
                            return false;
                        }
                        block17 : switch (kind) {
                            case 260: {
                                if (!argument.isTypeArgumentContainedBy(otherArgument)) return false;
                                break;
                            }
                            case 516: {
                                WildcardBinding wildcard = (WildcardBinding)argument;
                                WildcardBinding otherWildcard = (WildcardBinding)otherArgument;
                                switch (wildcard.boundKind) {
                                    case 1: {
                                        if (otherWildcard.boundKind != 0) return false;
                                        if (wildcard.bound != wildcard.typeVariable().upperBound()) return false;
                                        break block17;
                                    }
                                    case 2: {
                                        break;
                                    }
                                    case 0: {
                                        if (otherWildcard.boundKind != 1) return false;
                                        if (otherWildcard.bound != otherWildcard.typeVariable().upperBound()) return false;
                                        break block17;
                                    }
                                }
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public boolean isTypeArgumentIntersecting(TypeBinding otherArgument) {
        if (this == otherArgument) {
            return true;
        }
        switch (this.kind()) {
            case 4100: {
                return true;
            }
            case 516: {
                switch (otherArgument.kind()) {
                    case 4100: {
                        return true;
                    }
                    case 516: {
                        TypeBinding lowerBound1 = null;
                        TypeBinding upperBound1 = null;
                        WildcardBinding wildcard = (WildcardBinding)this;
                        switch (wildcard.boundKind) {
                            case 1: {
                                upperBound1 = wildcard.bound;
                                break;
                            }
                            case 2: {
                                lowerBound1 = wildcard.bound;
                            }
                        }
                        TypeBinding lowerBound2 = null;
                        TypeBinding upperBound2 = null;
                        WildcardBinding otherWildcard = (WildcardBinding)otherArgument;
                        switch (otherWildcard.boundKind) {
                            case 1: {
                                upperBound2 = otherWildcard.bound;
                                break;
                            }
                            case 2: {
                                lowerBound2 = otherWildcard.bound;
                            }
                        }
                        if (lowerBound1 != null) {
                            if (lowerBound2 != null) {
                                return true;
                            }
                            if (upperBound2 != null) {
                                return lowerBound1.isCompatibleWith(upperBound2);
                            }
                            return true;
                        }
                        if (upperBound1 != null) {
                            if (upperBound1.isTypeVariable()) {
                                return true;
                            }
                            if (lowerBound2 != null) {
                                return lowerBound2.isCompatibleWith(upperBound1);
                            }
                            if (upperBound2 != null) {
                                if (upperBound1.isInterface()) {
                                    if (upperBound2.isInterface()) {
                                        return true;
                                    }
                                    if (upperBound2.isArrayType() || upperBound2 instanceof ReferenceBinding && ((ReferenceBinding)upperBound2).isFinal()) {
                                        return upperBound2.isCompatibleWith(upperBound1);
                                    }
                                    return true;
                                }
                                if (upperBound2.isInterface()) {
                                    if (upperBound1.isArrayType() || upperBound1 instanceof ReferenceBinding && ((ReferenceBinding)upperBound1).isFinal()) {
                                        return upperBound1.isCompatibleWith(upperBound2);
                                    }
                                } else {
                                    return upperBound1.isCompatibleWith(upperBound2);
                                }
                                return true;
                            }
                            return true;
                        }
                        return true;
                    }
                }
                WildcardBinding wildcard = (WildcardBinding)this;
                switch (wildcard.boundKind) {
                    case 1: {
                        return otherArgument.isCompatibleWith(wildcard.bound);
                    }
                    case 2: {
                        return wildcard.bound.isCompatibleWith(otherArgument);
                    }
                }
                return true;
            }
        }
        switch (otherArgument.kind()) {
            case 4100: {
                return true;
            }
            case 516: {
                WildcardBinding otherWildcard = (WildcardBinding)otherArgument;
                switch (otherWildcard.boundKind) {
                    case 1: {
                        return this.isCompatibleWith(otherWildcard.bound);
                    }
                    case 2: {
                        return otherWildcard.bound.isCompatibleWith(this);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean isTypeVariable() {
        return false;
    }

    public boolean isUnboundWildcard() {
        return false;
    }

    public boolean isUncheckedException(boolean includeSupertype) {
        return false;
    }

    public boolean isWildcard() {
        return false;
    }

    public int kind() {
        return 4;
    }

    public TypeBinding leafComponentType() {
        return this;
    }

    public boolean needsUncheckedConversion(TypeBinding targetType) {
        if (this == targetType) {
            return false;
        }
        if (!((targetType = targetType.leafComponentType()) instanceof ReferenceBinding)) {
            return false;
        }
        TypeBinding currentType = this.leafComponentType();
        TypeBinding match = currentType.findSuperTypeWithSameErasure(targetType);
        if (!(match instanceof ReferenceBinding)) {
            return false;
        }
        ReferenceBinding compatible = (ReferenceBinding)match;
        while (compatible.isRawType()) {
            if (targetType.isBoundParameterizedType()) {
                return true;
            }
            if (compatible.isStatic() || (compatible = compatible.enclosingType()) == null || (targetType = targetType.enclosingType()) == null) break;
        }
        return false;
    }

    public char[] qualifiedPackageName() {
        PackageBinding packageBinding = this.getPackage();
        return packageBinding == null || packageBinding.compoundName == CharOperation.NO_CHAR_CHAR ? CharOperation.NO_CHAR : packageBinding.readableName();
    }

    public abstract char[] qualifiedSourceName();

    public char[] signature() {
        return this.constantPoolName();
    }

    public abstract char[] sourceName();

    public void swapUnresolved(UnresolvedReferenceBinding unresolvedType, ReferenceBinding resolvedType, LookupEnvironment environment) {
    }

    public TypeVariableBinding[] typeVariables() {
        return Binding.NO_TYPE_VARIABLES;
    }
}

