/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.converter.impl;

import java.util.HashMap;
import java.util.Map;
import org.seasar.cubby.converter.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConverter
implements Converter {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY = new HashMap();

    @Override
    public boolean canConvert(Class<?> parameterType, Class<?> objectType) {
        if (this.getObjectType().isAssignableFrom(objectType)) {
            return true;
        }
        if (PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.containsKey(objectType)) {
            Class<?> wrapperArray = PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.get(objectType);
            return this.canConvert(parameterType, wrapperArray);
        }
        return false;
    }

    static {
        PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.put(boolean[].class, Boolean[].class);
        PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.put(char[].class, Character[].class);
        PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.put(byte[].class, Byte[].class);
        PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.put(short[].class, Short[].class);
        PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.put(int[].class, Integer[].class);
        PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.put(long[].class, Long[].class);
        PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.put(float[].class, Float[].class);
        PRIMITIVE_ARRAY_TO_WRAPPER_ARRAY.put(double[].class, Double[].class);
    }
}

