/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.internal.controller.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.seasar.cubby.action.Action;
import org.seasar.cubby.action.ActionContext;
import org.seasar.cubby.action.ActionErrors;
import org.seasar.cubby.action.ActionException;
import org.seasar.cubby.action.Form;
import org.seasar.cubby.action.InitializeMethod;
import org.seasar.cubby.action.PostRenderMethod;
import org.seasar.cubby.action.PreRenderMethod;
import org.seasar.cubby.action.RequestParameterBindingType;
import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.spi.beans.Attribute;
import org.seasar.cubby.spi.beans.BeanDesc;
import org.seasar.cubby.spi.beans.BeanDescFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActionContextImpl
implements ActionContext {
    private final Object action;
    private final Class<?> actionClass;
    private final Method actionMethod;
    private final ActionErrors actionErrors;
    private final Map<String, Object> flashMap;

    public ActionContextImpl(HttpServletRequest request, Object action, Class<?> actionClass, Method actionMethod, ActionErrors actionErrors, Map<String, Object> flashMap) {
        this.action = action;
        this.actionClass = actionClass;
        this.actionMethod = actionMethod;
        this.actionErrors = actionErrors;
        this.flashMap = flashMap;
        if (action instanceof Action) {
            this.initializeAction((Action)action, actionErrors, flashMap);
        }
    }

    private void initializeAction(Action action, ActionErrors actionErrors, Map<String, Object> flashMap) {
        action.setErrors(actionErrors);
        action.setFlash(flashMap);
    }

    @Override
    public Object getAction() {
        return this.action;
    }

    @Override
    public Class<?> getActionClass() {
        return this.actionClass;
    }

    @Override
    public Method getActionMethod() {
        return this.actionMethod;
    }

    @Override
    public Object getFormBean() {
        Object formBean;
        Form form = this.getForm();
        if (form == null) {
            return this.action;
        }
        if (form.bindingType() == RequestParameterBindingType.NONE) {
            return null;
        }
        if ("this".equals(form.value())) {
            return this.action;
        }
        String attributeName = form.value();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(this.actionClass);
        if (beanDesc.hasPropertyAttribute(attributeName)) {
            Attribute attribute = beanDesc.getPropertyAttribute(attributeName);
            formBean = attribute.getValue(this.action);
            if (formBean == null) {
                throw new ActionException(LogMessages.format("ECUB0102", this.actionClass, attributeName));
            }
        } else if (beanDesc.hasFieldAttribute(attributeName)) {
            Attribute attribute = beanDesc.getFieldAttribute(attributeName);
            formBean = attribute.getValue(this.action);
            if (formBean == null) {
                throw new ActionException(LogMessages.format("ECUB0111", this.actionClass, attributeName));
            }
        } else {
            throw new ActionException(LogMessages.format("ECUB0112", this.actionClass, attributeName));
        }
        return formBean;
    }

    private Form getForm() {
        Form form = this.actionMethod.isAnnotationPresent(Form.class) ? this.actionMethod.getAnnotation(Form.class) : this.actionClass.getAnnotation(Form.class);
        return form;
    }

    @Override
    public boolean isBindRequestParameterToAllProperties() {
        Form form = this.getForm();
        if (form == null) {
            return false;
        }
        RequestParameterBindingType type = form.bindingType();
        switch (type) {
            case ALL_PROPERTIES: {
                return true;
            }
            case ONLY_SPECIFIED_PROPERTIES: {
                return false;
            }
        }
        throw new IllegalStateException(type.toString());
    }

    @Override
    public void invokeInitializeMethod() {
        if (this.action instanceof Action) {
            ((Action)this.action).invokeInitializeMethod(this.actionMethod);
        } else if (this.actionMethod.isAnnotationPresent(InitializeMethod.class)) {
            InitializeMethod initializeMethod = this.actionMethod.getAnnotation(InitializeMethod.class);
            String methodName = initializeMethod.value();
            this.invoke(this.action, methodName);
        }
    }

    @Override
    public void invokePreRenderMethod() {
        if (this.action instanceof Action) {
            ((Action)this.action).invokePreRenderMethod(this.actionMethod);
        } else if (this.actionMethod.isAnnotationPresent(PreRenderMethod.class)) {
            PreRenderMethod preRenderMethod = this.actionMethod.getAnnotation(PreRenderMethod.class);
            String methodName = preRenderMethod.value();
            this.invoke(this.action, methodName);
        }
    }

    @Override
    public void invokePostRenderMethod() {
        if (this.action instanceof Action) {
            ((Action)this.action).invokePostRenderMethod(this.actionMethod);
        } else if (this.actionMethod.isAnnotationPresent(PostRenderMethod.class)) {
            PostRenderMethod postRenderMethod = this.actionMethod.getAnnotation(PostRenderMethod.class);
            String methodName = postRenderMethod.value();
            this.invoke(this.action, methodName);
        }
    }

    @Override
    public ActionErrors getActionErrors() {
        return this.actionErrors;
    }

    @Override
    public Map<String, Object> getFlashMap() {
        return this.flashMap;
    }

    @Override
    public void clearFlash() {
        if (this.flashMap != null) {
            this.flashMap.clear();
        }
    }

    private void invoke(Object action, String methodName) {
        try {
            Method method = action.getClass().getMethod(methodName, new Class[0]);
            method.invoke(action, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ActionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ActionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ActionException(e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ActionContext[");
        builder.append("action=").append(this.action);
        builder.append(",actionClass=").append(this.actionClass);
        builder.append(",actionMethod=").append(this.actionMethod);
        builder.append("]");
        return builder.toString();
    }
}

