/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugins.oval.validation;

import java.util.List;
import java.util.Map;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.Validator;
import net.sf.oval.context.ClassContext;
import net.sf.oval.context.ConstructorParameterContext;
import net.sf.oval.context.FieldContext;
import net.sf.oval.context.MethodEntryContext;
import net.sf.oval.context.MethodExitContext;
import net.sf.oval.context.MethodParameterContext;
import net.sf.oval.context.MethodReturnValueContext;
import net.sf.oval.context.OValContext;
import org.seasar.cubby.action.ActionErrors;
import org.seasar.cubby.action.FieldInfo;
import org.seasar.cubby.plugins.oval.validation.OValValidationContext;
import org.seasar.cubby.spi.ContainerProvider;
import org.seasar.cubby.spi.ProviderFactory;
import org.seasar.cubby.spi.container.Container;
import org.seasar.cubby.spi.container.LookupException;
import org.seasar.cubby.validator.ValidationException;
import org.seasar.cubby.validator.ValidationRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OValValidationRule
implements ValidationRule {
    private final String resourceKeyPrefix;

    public OValValidationRule() {
        this(null);
    }

    public OValValidationRule(String resourceKeyPrefix) {
        this.resourceKeyPrefix = resourceKeyPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Map<String, Object[]> params, Object form, ActionErrors errors) throws ValidationException {
        OValValidationContext context = OValValidationContext.get();
        context.setResourceKeyPrefix(this.resourceKeyPrefix);
        try {
            Validator validator = this.buildValidator();
            List violations = validator.validate(form);
            this.processViolations(violations, errors);
        }
        finally {
            OValValidationContext.remove();
        }
    }

    protected Validator buildValidator() {
        Container container = ((ContainerProvider)ProviderFactory.get(ContainerProvider.class)).getContainer();
        try {
            return (Validator)container.lookup(Validator.class);
        }
        catch (LookupException e) {
            return new Validator();
        }
    }

    protected void processViolations(List<ConstraintViolation> violations, ActionErrors errors) {
        for (ConstraintViolation violation : violations) {
            String message = violation.getMessage();
            FieldInfo fieldInfo = this.createFieldInfo(violation.getContext());
            if (fieldInfo != null) {
                errors.add(message, new FieldInfo[]{fieldInfo});
                continue;
            }
            errors.add(message);
        }
    }

    protected FieldInfo createFieldInfo(OValContext ovalContext) {
        FieldInfo fieldInfo;
        if (ovalContext instanceof ClassContext) {
            fieldInfo = null;
        } else if (ovalContext instanceof FieldContext) {
            FieldContext ctx = (FieldContext)ovalContext;
            fieldInfo = new FieldInfo(ctx.getField().getName());
        } else if (ovalContext instanceof ConstructorParameterContext) {
            ConstructorParameterContext ctx = (ConstructorParameterContext)ovalContext;
            fieldInfo = new FieldInfo(ctx.getParameterName());
        } else if (ovalContext instanceof MethodParameterContext) {
            MethodParameterContext ctx = (MethodParameterContext)ovalContext;
            fieldInfo = new FieldInfo(ctx.getParameterName());
        } else if (ovalContext instanceof MethodEntryContext) {
            MethodEntryContext ctx = (MethodEntryContext)ovalContext;
            fieldInfo = new FieldInfo(ctx.getMethod().getName());
        } else if (ovalContext instanceof MethodExitContext) {
            MethodExitContext ctx = (MethodExitContext)ovalContext;
            fieldInfo = new FieldInfo(ctx.getMethod().getName());
        } else if (ovalContext instanceof MethodReturnValueContext) {
            MethodReturnValueContext ctx = (MethodReturnValueContext)ovalContext;
            fieldInfo = new FieldInfo(ctx.getMethod().getName());
        } else {
            fieldInfo = null;
        }
        return fieldInfo;
    }
}

