/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.S2Container;

public class RemoveSessionInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    protected S2Container container;
    protected String[] name;

    public RemoveSessionInterceptor(S2Container container) {
        this.container = container;
    }

    public String[] getName() {
        return this.name;
    }

    public void setName(String[] name) {
        this.name = name;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result = invocation.proceed();
        this.removeSession();
        return result;
    }

    protected void removeSession() {
        if (this.name == null || this.name.length == 0) {
            return;
        }
        ExternalContext context = this.container.getRoot().getExternalContext();
        if (context == null) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)context.getRequest();
        if (request == null) {
            return;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        for (int i = 0; i < this.name.length; ++i) {
            session.removeAttribute(this.name[i]);
        }
    }
}

