/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;

public class Area3DEval
implements AreaEval {
    private Area3DPtg delegate;
    private ValueEval[] values;

    public Area3DEval(Ptg ptg, ValueEval[] values) {
        this.values = values;
        this.delegate = (Area3DPtg)ptg;
    }

    public short getFirstColumn() {
        return this.delegate.getFirstColumn();
    }

    public int getFirstRow() {
        return this.delegate.getFirstRow();
    }

    public short getLastColumn() {
        return this.delegate.getLastColumn();
    }

    public int getLastRow() {
        return this.delegate.getLastRow();
    }

    public ValueEval[] getValues() {
        return this.values;
    }

    public ValueEval getValueAt(int row, short col) {
        int index = (row - this.getFirstRow()) * (col - this.getFirstColumn());
        ValueEval retval = index < 0 || index >= this.values.length ? ErrorEval.VALUE_INVALID : this.values[index];
        return retval;
    }

    public boolean contains(int row, short col) {
        return this.getFirstRow() <= row && this.getLastRow() >= row && this.getFirstColumn() <= col && this.getLastColumn() >= col;
    }

    public boolean containsRow(int row) {
        return this.getFirstRow() <= row && this.getLastRow() >= row;
    }

    public boolean containsColumn(short col) {
        return this.getFirstColumn() <= col && this.getLastColumn() >= col;
    }

    public boolean isColumn() {
        return this.delegate.getFirstColumn() == this.delegate.getLastColumn();
    }

    public boolean isRow() {
        return this.delegate.getFirstRow() == this.delegate.getLastRow();
    }
}

