/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.external.servlet;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.framework.container.external.AbstractExternalContextMap;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.EmptyIterator;
import org.seasar.framework.util.EnumerationIterator;

public class HttpSessionMap
extends AbstractExternalContextMap {
    private static final Iterator EMPTY_ITERATOR = new EmptyIterator();
    private HttpServletRequest request;

    public HttpSessionMap(HttpServletRequest request) {
        AssertionUtil.assertNotNull("request is null.", request);
        this.request = request;
    }

    protected Object getAttribute(String key) {
        HttpSession session = this.getSession();
        return session != null ? session.getAttribute(key) : null;
    }

    protected void setAttribute(String key, Object value) {
        this.request.getSession(true).setAttribute(key, value);
    }

    protected Iterator getAttributeNames() {
        HttpSession session = this.getSession();
        return session != null ? new EnumerationIterator(session.getAttributeNames()) : EMPTY_ITERATOR;
    }

    protected void removeAttribute(String key) {
        HttpSession session = this.getSession();
        if (session != null) {
            session.removeAttribute(key);
        }
    }

    private HttpSession getSession() {
        return this.request.getSession(false);
    }
}

