/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.seasar.cubby.action.ActionErrors;
import org.seasar.cubby.action.FieldInfo;
import org.seasar.cubby.action.MessageInfo;
import org.seasar.cubby.validator.ArrayFieldValidator;
import org.seasar.cubby.validator.ScalarFieldValidator;
import org.seasar.cubby.validator.ValidationContext;
import org.seasar.cubby.validator.ValidationRule;
import org.seasar.cubby.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldValidationRule
implements ValidationRule {
    private static final Object[] EMPTY_VALUES = new Object[]{""};
    private final String fieldName;
    private final String fieldNameKey;
    private final List<ValidationInvoker> invokers = new ArrayList<ValidationInvoker>();

    public FieldValidationRule(String fieldName, Validator ... validators) {
        this(fieldName, fieldName, validators);
    }

    public FieldValidationRule(String fieldName, String fieldNameKey, Validator ... validators) {
        this.fieldName = fieldName;
        this.fieldNameKey = fieldNameKey;
        for (Validator validator : validators) {
            ValidationInvoker invoker = this.createInvoker(validator);
            this.invokers.add(invoker);
        }
    }

    @Override
    public void apply(Map<String, Object[]> params, Object form, ActionErrors errors) {
        Object[] values = this.getValues(params, this.fieldName);
        for (ValidationInvoker invoker : this.invokers) {
            invoker.invoke(this, values, errors);
        }
    }

    private Object[] getValues(Map<String, Object[]> params, String fieldName) {
        Object[] values = params.get(fieldName);
        if (values != null) {
            return values;
        }
        return EMPTY_VALUES;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldNameKey() {
        return this.fieldNameKey;
    }

    private ValidationInvoker createInvoker(Validator validator) {
        ValidationInvoker invoker;
        if (validator instanceof ArrayFieldValidator) {
            invoker = new ArrayFieldValidationInvoker((ArrayFieldValidator)validator);
        } else if (validator instanceof ScalarFieldValidator) {
            invoker = new ScalarFieldValidationInvoker((ScalarFieldValidator)validator);
        } else {
            throw new UnsupportedOperationException();
        }
        return invoker;
    }

    private static class ScalarFieldValidationInvoker
    implements ValidationInvoker {
        private final ScalarFieldValidator validator;

        public ScalarFieldValidationInvoker(ScalarFieldValidator validator) {
            this.validator = validator;
        }

        public void invoke(FieldValidationRule validationRule, Object[] values, ActionErrors errors) {
            for (int i = 0; i < values.length; ++i) {
                ValidationContext context = new ValidationContext();
                FieldInfo fieldInfo = new FieldInfo(validationRule.getFieldName(), i);
                this.validator.validate(context, values[i]);
                for (MessageInfo messageInfo : context.getMessageInfos()) {
                    String message = messageInfo.toMessage(validationRule.getFieldNameKey());
                    errors.add(message, fieldInfo);
                }
            }
        }
    }

    private static class ArrayFieldValidationInvoker
    implements ValidationInvoker {
        private final ArrayFieldValidator validator;

        public ArrayFieldValidationInvoker(ArrayFieldValidator validator) {
            this.validator = validator;
        }

        public void invoke(FieldValidationRule validationRule, Object[] values, ActionErrors errors) {
            ValidationContext context = new ValidationContext();
            FieldInfo fieldInfo = new FieldInfo(validationRule.getFieldName());
            this.validator.validate(context, values);
            for (MessageInfo messageInfo : context.getMessageInfos()) {
                String message = messageInfo.toMessage(validationRule.getFieldNameKey());
                errors.add(message, fieldInfo);
            }
        }
    }

    private static interface ValidationInvoker {
        public void invoke(FieldValidationRule var1, Object[] var2, ActionErrors var3);
    }
}

