/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.internal.controller.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.cubby.action.ActionContext;
import org.seasar.cubby.action.ActionErrors;
import org.seasar.cubby.action.ActionException;
import org.seasar.cubby.action.ActionResult;
import org.seasar.cubby.action.Validation;
import org.seasar.cubby.internal.controller.ActionProcessor;
import org.seasar.cubby.internal.controller.ActionResultWrapper;
import org.seasar.cubby.internal.controller.ConversionFailure;
import org.seasar.cubby.internal.controller.RequestParameterBinder;
import org.seasar.cubby.internal.controller.impl.ActionContextImpl;
import org.seasar.cubby.internal.controller.impl.ActionErrorsImpl;
import org.seasar.cubby.internal.controller.impl.ActionResultWrapperImpl;
import org.seasar.cubby.internal.controller.impl.FlashMapImpl;
import org.seasar.cubby.internal.controller.impl.RequestParameterBinderImpl;
import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.internal.util.RequestUtils;
import org.seasar.cubby.plugin.ActionInvocation;
import org.seasar.cubby.plugin.Plugin;
import org.seasar.cubby.plugin.PluginRegistry;
import org.seasar.cubby.plugin.ValidationInvocation;
import org.seasar.cubby.routing.Routing;
import org.seasar.cubby.spi.ContainerProvider;
import org.seasar.cubby.spi.ProviderFactory;
import org.seasar.cubby.spi.container.Container;
import org.seasar.cubby.validator.ValidationException;
import org.seasar.cubby.validator.ValidationFailBehaviour;
import org.seasar.cubby.validator.ValidationRules;
import org.seasar.cubby.validator.ValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionProcessorImpl
implements ActionProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ActionProcessorImpl.class);

    @Override
    public ActionResultWrapper process(HttpServletRequest request, HttpServletResponse response, Routing routing) throws Exception {
        Method actionMethod = routing.getActionMethod();
        if (logger.isDebugEnabled()) {
            logger.debug(LogMessages.format("DCUB0004", request.getRequestURI()));
            logger.debug(LogMessages.format("DCUB0005", actionMethod));
        }
        Class<?> actionClass = routing.getActionClass();
        Container container = ProviderFactory.get(ContainerProvider.class).getContainer();
        Object action = container.lookup(actionClass);
        request.setAttribute("action", action);
        HttpServletRequest wrapeeRequest = (HttpServletRequest)request.getAttribute("org.seasar.cubby.wrapeeRequest");
        ActionErrors actionErrors = this.setupActionErrors((ServletRequest)wrapeeRequest);
        Map<String, Object> flashMap = this.setupFlashMap((ServletRequest)wrapeeRequest);
        ActionContextImpl actionContext = new ActionContextImpl(request, action, actionClass, actionMethod, actionErrors, flashMap);
        request.setAttribute("org.seasar.cubby.actionContext", (Object)actionContext);
        actionContext.invokeInitializeMethod();
        ActionInvocationImpl actionInvocation = new ActionInvocationImpl(request, response, actionContext);
        ActionResult actionResult = (ActionResult)actionInvocation.proceed();
        if (actionResult == null) {
            throw new ActionException(LogMessages.format("ECUB0101", actionMethod));
        }
        ActionResultWrapperImpl actionResultWrapper = new ActionResultWrapperImpl(actionResult, actionContext);
        return actionResultWrapper;
    }

    private ActionErrors setupActionErrors(ServletRequest request) {
        ActionErrors actionErrors = (ActionErrors)request.getAttribute("errors");
        if (actionErrors != null) {
            return actionErrors;
        }
        ActionErrorsImpl newActionErrors = new ActionErrorsImpl();
        request.setAttribute("errors", (Object)newActionErrors);
        return newActionErrors;
    }

    private Map<String, Object> setupFlashMap(ServletRequest request) {
        Map flashMap = (Map)request.getAttribute("flash");
        if (flashMap != null) {
            return flashMap;
        }
        FlashMapImpl newFlashMap = new FlashMapImpl((HttpServletRequest)request);
        request.setAttribute("flash", (Object)newFlashMap);
        return newFlashMap;
    }

    static class ValidationInvocationImpl
    implements ValidationInvocation {
        private final RequestParameterBinder requestParameterBinder = new RequestParameterBinderImpl();
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final ActionContext actionContext;
        private final Iterator<Plugin> pluginsIterator;

        public ValidationInvocationImpl(HttpServletRequest request, HttpServletResponse response, ActionContext actionContext) {
            this.request = request;
            this.response = response;
            this.actionContext = actionContext;
            PluginRegistry pluginRegistry = PluginRegistry.getInstance();
            this.pluginsIterator = pluginRegistry.getPlugins().iterator();
        }

        public ActionResult proceed() throws Exception {
            ActionResult actionResult;
            if (this.pluginsIterator.hasNext()) {
                Plugin plugin = this.pluginsIterator.next();
                actionResult = plugin.invokeValidation(this);
            } else {
                Map parameterMap = (Map)RequestUtils.getAttribute((ServletRequest)this.request, "org.seasar.cubby.params");
                Object formBean = this.actionContext.getFormBean();
                if (formBean != null) {
                    List<ConversionFailure> conversionFailures = this.requestParameterBinder.bind(parameterMap, formBean, this.actionContext);
                    this.request.setAttribute("org.seasar.cubby.conversionFailures", conversionFailures);
                }
                try {
                    Validation validation = ValidationUtils.getValidation(this.actionContext.getActionMethod());
                    if (validation != null) {
                        ValidationRules validationRules = ValidationUtils.getValidationRules(this.actionContext.getAction(), validation.rules());
                        validationRules.validate(parameterMap, formBean, this.actionContext.getActionErrors());
                    }
                    try {
                        Object action = this.actionContext.getAction();
                        Method actionMethod = this.actionContext.getActionMethod();
                        actionResult = (ActionResult)actionMethod.invoke(action, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof ValidationException) {
                            throw (ValidationException)cause;
                        }
                        throw e;
                    }
                }
                catch (ValidationException e) {
                    this.request.setAttribute("org.seasar.cubby.validationFail", (Object)Boolean.TRUE);
                    ValidationFailBehaviour behaviour = e.getBehaviour();
                    return behaviour.getValidationErrorActionResult(this.actionContext);
                }
            }
            return actionResult;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }

        public ActionContext getActionContext() {
            return this.actionContext;
        }
    }

    static class ActionInvocationImpl
    implements ActionInvocation {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final ActionContext actionContext;
        private final Iterator<Plugin> pluginsIterator;

        public ActionInvocationImpl(HttpServletRequest request, HttpServletResponse response, ActionContext actionContext) {
            this.request = request;
            this.response = response;
            this.actionContext = actionContext;
            PluginRegistry pluginRegistry = PluginRegistry.getInstance();
            this.pluginsIterator = pluginRegistry.getPlugins().iterator();
        }

        public ActionResult proceed() throws Exception {
            if (!this.pluginsIterator.hasNext()) {
                ValidationInvocationImpl validationInvocation = new ValidationInvocationImpl(this.request, this.response, this.actionContext);
                return (ActionResult)validationInvocation.proceed();
            }
            Plugin plugin = this.pluginsIterator.next();
            ActionResult actionResult = plugin.invokeAction(this);
            return actionResult;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }

        public ActionContext getActionContext() {
            return this.actionContext;
        }
    }
}

