/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.cubby.routing.InternalForwardInfo;
import org.seasar.cubby.routing.Router;
import org.seasar.cubby.routing.Routing;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.StringUtil;

public class RequestRoutingFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(RequestRoutingFilter.class);
    public static final String IGNORE_PATH_PATTERN = "ignorePathPattern";
    private final List<Pattern> ignorePathPatterns = new ArrayList<Pattern>();

    public void init(FilterConfig config) throws ServletException {
        String ignorePathPatternString = config.getInitParameter(IGNORE_PATH_PATTERN);
        if (!StringUtil.isEmpty((String)ignorePathPatternString)) {
            StringTokenizer tokenizer = new StringTokenizer(ignorePathPatternString, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                Pattern pattern = Pattern.compile(token);
                this.ignorePathPatterns.add(pattern);
            }
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        S2Container container = SingletonS2ContainerFactory.getContainer();
        Router router = (Router)container.getComponent(Router.class);
        InternalForwardInfo internalForwardInfo = router.routing(request, response, this.ignorePathPatterns);
        if (internalForwardInfo != null) {
            String internalForwardPath = internalForwardInfo.getInternalForwardPath();
            Map<String, Routing> onSubmitRoutings = internalForwardInfo.getOnSubmitRoutings();
            if (logger.isDebugEnabled()) {
                logger.log("DCUB0001", new Object[]{internalForwardPath, onSubmitRoutings});
                logger.log("DCUB0015", new Object[]{onSubmitRoutings});
            }
            request.setAttribute("org.seasar.cubby.routings", onSubmitRoutings);
            RequestDispatcher requestDispatcher = request.getRequestDispatcher(internalForwardPath);
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

