/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.converter.impl;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import org.seasar.cubby.converter.ConversionHelper;
import org.seasar.cubby.converter.impl.AbstractConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTimestampConverter
extends AbstractConverter {
    @Override
    public Class<?> getObjectType() {
        return Timestamp.class;
    }

    @Override
    public Object convertToObject(Object value, Class<?> objectType, ConversionHelper helper) {
        if (value == null) {
            return null;
        }
        DateFormat dateFormat = helper.getFormatPattern().getTimestampFormat();
        return this.toTimestamp((String)value, dateFormat);
    }

    protected Timestamp toTimestamp(String date, DateFormat dateFormat) {
        if (date == null || date.length() == 0) {
            return null;
        }
        try {
            return new Timestamp(dateFormat.parse(date).getTime());
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public String convertToString(Object value, ConversionHelper helper) {
        if (value == null) {
            return null;
        }
        DateFormat formatter = helper.getFormatPattern().getTimestampFormat();
        return formatter.format((Timestamp)value);
    }
}

