/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.controller.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.seasar.cubby.controller.RequestParser;
import org.seasar.cubby.exception.FileUploadRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartRequestParserImpl
implements RequestParser {
    static final int DEFAULT_PRIORITY = 0x7FFFFFFE;
    private final S2Container container;
    private int priority = 0x7FFFFFFE;

    public MultipartRequestParserImpl(S2Container container) {
        this.container = container;
    }

    @Override
    public Map<String, Object[]> getParameterMap(HttpServletRequest request) {
        HashMap<String, Object[]> parameterMap = new HashMap<String, Object[]>(request.getParameterMap());
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            S2Container root = this.container.getRoot();
            FileUpload fileUpload = (FileUpload)root.getComponent(FileUpload.class);
            RequestContext requestContext = (RequestContext)root.getComponent(RequestContext.class);
            parameterMap.putAll(this.getMultipartParameterMap(fileUpload, requestContext));
        }
        return parameterMap;
    }

    Map<String, Object[]> getMultipartParameterMap(FileUpload fileUpload, RequestContext requestContext) {
        try {
            String encoding = requestContext.getCharacterEncoding();
            fileUpload.setHeaderEncoding(encoding);
            List items = fileUpload.parseRequest(requestContext);
            Map<String, Object[]> parameterMap = this.toParameterMap(encoding, items);
            return parameterMap;
        }
        catch (FileUploadException e) {
            Object[] args;
            String messageCode;
            if (e instanceof FileUploadBase.SizeLimitExceededException) {
                FileUploadBase.SizeLimitExceededException sle = (FileUploadBase.SizeLimitExceededException)e;
                messageCode = "ECUB0202";
                args = new Object[]{sle.getPermittedSize(), sle.getActualSize()};
            } else {
                messageCode = "ECUB0201";
                args = new Object[]{e};
            }
            throw new FileUploadRuntimeException(messageCode, args, e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    Map<String, Object[]> toParameterMap(String encoding, List<FileItem> items) throws UnsupportedEncodingException {
        LinkedHashMap<String, List<Object>> valueListParameterMap = new LinkedHashMap<String, List<Object>>();
        for (FileItem item : items) {
            List<String> values;
            Object value = item.isFormField() ? item.getString(encoding) : (StringUtil.isEmpty((String)item.getName()) || item.getSize() == 0L ? null : item);
            if (valueListParameterMap.containsKey(item.getFieldName())) {
                values = (List)valueListParameterMap.get(item.getFieldName());
            } else {
                values = new ArrayList();
                valueListParameterMap.put(item.getFieldName(), values);
            }
            values.add((String)value);
        }
        Map<String, Object[]> parameterMap = this.fromValueListToValueArray(valueListParameterMap);
        return parameterMap;
    }

    Map<String, Object[]> fromValueListToValueArray(Map<String, List<Object>> collectParameterMap) {
        HashMap<String, Object[]> parameterMap = new HashMap<String, Object[]>();
        for (Map.Entry<String, List<Object>> entry : collectParameterMap.entrySet()) {
            List<Object> values = entry.getValue();
            String[] valueArray = values.get(0) instanceof String ? new String[values.size()] : new FileItem[values.size()];
            parameterMap.put(entry.getKey(), values.toArray(valueArray));
        }
        return parameterMap;
    }

    @Override
    public boolean isParsable(HttpServletRequest request) {
        S2Container root = this.container.getRoot();
        if (root.hasComponentDef(RequestContext.class)) {
            RequestContext requestContext = (RequestContext)root.getComponent(RequestContext.class);
            return FileUpload.isMultipartContent((RequestContext)requestContext);
        }
        return false;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }
}

