/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.tags;

import java.util.Collection;
import java.util.Map;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.tagext.JspTag;
import javax.servlet.jsp.tagext.SimpleTag;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.seasar.cubby.action.ActionErrors;
import org.seasar.cubby.tags.FormTag;
import org.seasar.cubby.util.CubbyUtils;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TagUtils {
    private static final String ATTR_ERRORS = "errors";
    public static final Object REMOVE_ATTRIBUTE = new Object();

    TagUtils() {
    }

    public static ActionErrors errors(JspContext context) {
        return (ActionErrors)context.getAttribute(ATTR_ERRORS, 2);
    }

    private static Object[] paramValues(JspContext context, String name) {
        Map valuesMap = (Map)Map.class.cast(context.getAttribute("org.seasar.cubby.params", 2));
        Object[] values = valuesMap == null || !valuesMap.containsKey(name) ? new Object[]{} : (Object[])valuesMap.get(name);
        return values;
    }

    public static Object[] multipleFormValues(JspContext context, String[] outputValues, String name) {
        return TagUtils.multipleFormValues(context, outputValues, name, null);
    }

    public static Object[] multipleFormValues(JspContext context, String[] outputValues, String name, String checkedValue) {
        Object[] values = TagUtils.isValidationFail(context) ? TagUtils.paramValues(context, name) : (checkedValue != null ? new Object[]{checkedValue} : (outputValues == null ? TagUtils.paramValues(context, name) : outputValues));
        return values;
    }

    public static Object formValue(JspContext context, String[] outputValues, String name, Integer index, Object specifiedValue) {
        Object value;
        if (TagUtils.isValidationFail(context)) {
            if (specifiedValue == null) {
                Object[] values = TagUtils.paramValues(context, name);
                value = TagUtils.value(values, index);
            } else {
                Object[] values = TagUtils.paramValues(context, name);
                value = values.length == 0 ? specifiedValue : TagUtils.value(values, index);
            }
        } else if (specifiedValue != null) {
            value = specifiedValue;
        } else if (outputValues == null) {
            Object[] values = TagUtils.paramValues(context, name);
            value = TagUtils.value(values, index);
        } else {
            value = TagUtils.value(outputValues, index);
        }
        return value;
    }

    private static Object value(Object[] values, Integer index) {
        Object value = values == null ? "" : (index == null ? TagUtils.getElement(values, 0) : TagUtils.getElement(values, index));
        return value;
    }

    private static Object getElement(Object[] values, Integer index) {
        Object value = values.length <= index ? "" : values[index];
        return value;
    }

    private static boolean isValidationFail(JspContext context) {
        return Boolean.TRUE.equals(context.getAttribute("org.seasar.cubby.validationFail", 2));
    }

    public static String toAttr(Map<String, Object> map) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue() == REMOVE_ATTRIBUTE) continue;
            builder.append(key);
            builder.append("=\"");
            builder.append(CubbyUtils.escapeHtml(entry.getValue()));
            builder.append("\" ");
        }
        return builder.toString();
    }

    public static boolean contains(Object obj, String str) {
        if (obj instanceof Collection) {
            return ((Collection)obj).contains(str);
        }
        if (obj.getClass().isArray()) {
            for (Object value : (Object[])obj) {
                if (!TagUtils.equalsAsString(value, str)) continue;
                return true;
            }
            return false;
        }
        return TagUtils.equalsAsString(obj, str);
    }

    private static boolean equalsAsString(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null) {
            return false;
        }
        return obj1.toString().equals(obj2.toString());
    }

    public static void addClassName(Map<String, Object> dyn, String className) {
        String classValue = (String)dyn.get("class");
        classValue = StringUtil.isEmpty((String)classValue) ? className : classValue + " " + className;
        dyn.put("class", classValue);
    }

    public static String[] getOutputValues(SimpleTag tag, String name) {
        FormTag formTag = (FormTag)SimpleTagSupport.findAncestorWithClass((JspTag)tag, FormTag.class);
        if (formTag == null) {
            return null;
        }
        String[] outputValues = formTag.getValues(name);
        return outputValues;
    }
}

