/*
 * Copyright 2004-2008 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.cubby.action;

public class MockAction extends Action {

	public String value1;

	public String value2;

	private boolean prerendered = false;

	private boolean postrendered = false;

	@Override
	public void prerender() {
		super.prerender();
		prerendered = true;
	}

	@Override
	public void postrender() {
		super.postrender();
		postrendered = true;
	}

	public boolean isPrerendered() {
		return prerendered;
	}

	public boolean isPostrendered() {
		return postrendered;
	}

	public ActionResult dummy1() {
		return null;
	}

	public ActionResult dummy2() {
		return null;
	}

	public ActionResult index() {
		return null;
	}
}
