/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator.validators;

import org.seasar.cubby.validator.MessageHelper;
import org.seasar.cubby.validator.ScalarFieldValidator;
import org.seasar.cubby.validator.ValidationContext;
import org.seasar.framework.util.StringUtil;

public class MaxLengthValidator
implements ScalarFieldValidator {
    private final MessageHelper messageHelper;
    private final int max;

    public MaxLengthValidator(int max) {
        this(max, "valid.maxLength");
    }

    public MaxLengthValidator(int max, String messageKey) {
        this.max = max;
        this.messageHelper = new MessageHelper(messageKey);
    }

    public void validate(ValidationContext context, Object value) {
        if (value instanceof String) {
            String str = (String)value;
            if (StringUtil.isEmpty((String)((String)value))) {
                return;
            }
            if (str.length() <= this.max) {
                return;
            }
        } else if (value == null) {
            return;
        }
        context.addMessageInfo(this.messageHelper.createMessageInfo(this.max));
    }
}

