/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.unit;

import java.io.File;
import java.net.URL;

import junit.framework.AssertionFailedError;

import org.seasar.extension.dataset.ColumnType;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.DataWriter;
import org.seasar.extension.dataset.impl.DataSetImpl;
import org.seasar.extension.dataset.types.ColumnTypes;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.FileOutputStreamUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public abstract class CodeGenTestCaseExtension extends CodeGenTestCase {

    public CodeGenTestCaseExtension(String name) {
        super(name);
    }

    private int cnt;

    public void writeXls(File file, DataSet dataSet) {
        DataWriter writer = new XlsWriterExt(FileOutputStreamUtil.create(file));
        writer.write(dataSet);
    }

    public void assertEquals(String message, DataTable expected,
            DataTable actual) {

        message = message == null ? "" : message;
        message = message + ":TableName=" + expected.getTableName();
        assertEquals(message + ":RowSize", expected.getRowSize(), actual
                .getRowSize());
        boolean error = false;

        DataSet dataSet = new DataSetImpl();
        dataSet.addTable(expected);

        for (int i = 0; i < expected.getRowSize(); ++i) {
            DataRow expectedRow = expected.getRow(i);
            DataRow actualRow = actual.getRow(i);

            for (int j = 0; j < expected.getColumnSize(); ++j) {
                String columnName = null;

                columnName = expected.getColumnName(j);
                Object expectedValue = expectedRow.getValue(columnName);
                ColumnType ct = ColumnTypes.getColumnType(expectedValue);
                Object actualValue = actualRow.getValue(columnName);
                try {
                    if (!ct.equals(expectedValue, actualValue)) {
                        assertEquals(expectedValue, actualValue);
                    }
                } catch (AssertionFailedError e) {
                    expected.getColumn(columnName).setColumnType(
                            ColumnTypes.STRING);
                    if (expected.getColumn(columnName).isPrimaryKey()) {
                        expectedRow.setValue(columnName, "primaryKey(expected:"
                                + expectedValue + ")does not match!");
                        error = true;
                        break;
                    }
                    expectedRow.setValue(columnName, e.getMessage());
                    error = true;
                }
            }

        }

        if (error) {
            File file = getDir();
            writeXls(file, dataSet);
        }

    }

    private File getDir() {
        String className = ClassUtil.getShortClassName(getClass());
        URL url = ResourceUtil.getResourceNoException( className + "_" + getName(), "xls" );
        String fileName = className + "_" + getName() + "_" + (++cnt) + ".xls";
        if (url == null){
            return new File(ResourceUtil.getBuildDir(getClass()), fileName);
        } else {
            return new File( new File(url.getFile()).getParentFile(), fileName);
        }
    }

    
}
