/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModifierUtil {
    public static boolean isAbstract(Class<?> clazz) {
        Validate.notNull(clazz);
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isAbstract(Method method) {
        Validate.notNull((Object)method);
        int mod = method.getModifiers();
        return Modifier.isAbstract(mod);
    }

    public static boolean isFinal(Member member) {
        Validate.notNull((Object)member);
        return Modifier.isFinal(member.getModifiers());
    }

    public static boolean isInstanceMember(Member member) {
        Validate.notNull((Object)member);
        int mod = member.getModifiers();
        return !Modifier.isStatic(mod);
    }

    public static boolean isPublic(Member member) {
        Validate.notNull((Object)member);
        return Modifier.isPublic(member.getModifiers());
    }

    public static boolean isPublicStaticFinal(int modifier) {
        return Modifier.isPublic(modifier) && Modifier.isStatic(modifier) && Modifier.isFinal(modifier);
    }

    public static boolean isPublicStaticFinal(Member member) {
        Validate.notNull((Object)member);
        return ModifierUtil.isPublicStaticFinal(member.getModifiers());
    }

    public static boolean isTransient(Field field) {
        Validate.notNull((Object)field);
        return Modifier.isTransient(field.getModifiers());
    }

    private ModifierUtil() {
    }
}

