/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.validator.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.jiemamy.JiemamyContext;
import org.jiemamy.model.constraint.JmCheckConstraint;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.validator.AbstractProblem;
import org.jiemamy.validator.AbstractValidator;
import org.jiemamy.validator.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckConstraintValidator
extends AbstractValidator {
    public Collection<Problem> validate(JiemamyContext context) {
        ArrayList problems = Lists.newArrayList();
        for (JmTable table : context.getTables()) {
            int index = 0;
            for (JmCheckConstraint checkConstraint : table.getConstraints(JmCheckConstraint.class)) {
                this.validateCheckConstraint(problems, table, index, checkConstraint);
                ++index;
            }
        }
        return problems;
    }

    private boolean isValid(JmCheckConstraint checkConstraint) {
        return !StringUtils.isEmpty((String)checkConstraint.getExpression());
    }

    private void validateCheckConstraint(Collection<Problem> problems, JmTable table, int index, JmCheckConstraint checkConstraint) {
        if (!this.isValid(checkConstraint)) {
            if (StringUtils.isEmpty((String)checkConstraint.getName())) {
                problems.add(new EmptyExpressionProblem(table, checkConstraint, index));
            } else {
                problems.add(new EmptyExpressionProblem(table, checkConstraint));
            }
        }
    }

    static class EmptyExpressionProblem
    extends AbstractProblem {
        public EmptyExpressionProblem(JmTable table, JmCheckConstraint checkConstraint, int index) {
            super(checkConstraint, "E0031", new Object[]{table.getName(), index + 1});
        }

        EmptyExpressionProblem(JmTable table, JmCheckConstraint checkConstraint) {
            super(checkConstraint, "E0030", new Object[]{table.getName(), checkConstraint.getName()});
        }
    }
}

