/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.column;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.jiemamy.dddbase.AbstractOrderedEntity;
import org.jiemamy.dddbase.DefaultEntityRef;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.model.column.ColumnParameterKey;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.datatype.DataType;
import org.jiemamy.model.parameter.ParameterMap;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.model.table.TableNotFoundException;
import org.jiemamy.model.table.TooManyTablesFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJmColumn
extends AbstractOrderedEntity
implements JmColumn {
    private String name;
    private String logicalName;
    private String description;
    private DataType dataType;
    private String defaultValue;
    private ParameterMap params = new ParameterMap();

    public SimpleJmColumn() {
        this(UUID.randomUUID());
    }

    public SimpleJmColumn(UUID id) {
        super(id);
    }

    @Override
    public SimpleJmColumn clone() {
        SimpleJmColumn clone = (SimpleJmColumn)super.clone();
        clone.params = this.params.clone();
        return clone;
    }

    @Override
    public JmTable findDeclaringTable(Iterable<? extends JmTable> tables) {
        Validate.notNull(tables);
        Iterable c = Iterables.filter(tables, (Predicate)new Predicate<JmTable>(){

            public boolean apply(JmTable table) {
                Validate.notNull((Object)table);
                return table.getColumns().contains(SimpleJmColumn.this);
            }
        });
        try {
            return (JmTable)Iterables.getOnlyElement((Iterable)c);
        }
        catch (NoSuchElementException e) {
            throw new TableNotFoundException("contains " + this + " in " + tables);
        }
        catch (IllegalArgumentException e) {
            throw new TooManyTablesFoundException(c);
        }
    }

    @Override
    public DataType getDataType() {
        if (this.dataType == null) {
            return null;
        }
        return this.dataType.clone();
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLogicalName() {
        return this.logicalName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <T> T getParam(ColumnParameterKey<T> key) {
        return this.params.get(key);
    }

    @Override
    public ParameterMap getParams() {
        return this.params.clone();
    }

    public <T> void putParam(ColumnParameterKey<T> key, T value) {
        this.params.put(key, value);
    }

    public void removeParam(ColumnParameterKey<?> key) {
        this.params.remove(key);
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType == null ? null : dataType.clone();
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLogicalName(String logicalName) {
        this.logicalName = logicalName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EntityRef<? extends SimpleJmColumn> toReference() {
        return new DefaultEntityRef((Entity)this);
    }

    public String toString() {
        return super.toString() + "{name=" + this.name + ", type=" + this.dataType + "}";
    }

    ParameterMap breachEncapsulationOfParams() {
        return this.params;
    }
}

