/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.entity;

import java.util.Set;
import java.util.HashSet;

/**
 * DEFAULT_EXAMPLEテーブルのEntityです。
 * @author S2Dao-CodeGen
 */

@org.seasar.dao.annotation.tiger.Bean(table = "DEFAULT_EXAMPLE", versionNoProperty = "versionno")
public abstract class AbstractDefaultExample {

	private java.math.BigDecimal realDefault = new java.math.BigDecimal("1.1");
	private Long bigintDefault = new Long(1);
	private String stringDefault = "a";
	private java.util.Date dateMax = new java.util.Date(9999,11,31,23,59,59);
	private java.util.Date dateMin = new java.util.Date(1000,0,1,1,1,1);
	private java.util.Date dateCur = new java.util.Date();
	private java.util.Date dateNow = new java.util.Date();
	private java.sql.Time timeMax = new java.sql.Time(23,59,59);
	private java.sql.Time timeMin = new java.sql.Time(0,0,0);
	private java.sql.Time timeCur = new java.sql.Time(java.util.GregorianCalendar.getInstance().getTimeInMillis());
	private java.sql.Time timeNow = new java.sql.Time(java.util.GregorianCalendar.getInstance().getTimeInMillis());
	private java.sql.Timestamp timestampMax = new java.sql.Timestamp(9999,11,31,23,59,59,99);
	private java.sql.Timestamp timestampMin = new java.sql.Timestamp(1000,0,1,1,0,0,0);
	private java.sql.Timestamp timestampCur = new java.sql.Timestamp(java.util.GregorianCalendar.getInstance().getTimeInMillis());
	private java.sql.Timestamp timestampNow = new java.sql.Timestamp(java.util.GregorianCalendar.getInstance().getTimeInMillis());
	
	private Set<String> modifiedPropertySet = new HashSet<String>();

	/**
	 * 実数を返します。
	 * @return 実数
	 */
	@org.seasar.dao.annotation.tiger.Column("REAL_DEFAULT")
	public java.math.BigDecimal getRealDefault() {
		return realDefault;
	}

	/**
	 * 実数を設定します。
	 * @param realDefault 実数
	 */
	public void setRealDefault(java.math.BigDecimal realDefault) {
		modifiedPropertySet.add("realDefault");
		this.realDefault = realDefault;
	}

	/**
	 * 整数を返します。
	 * @return 整数
	 */
	@org.seasar.dao.annotation.tiger.Column("BIGINT_DEFAULT")
	public Long getBigintDefault() {
		return bigintDefault;
	}

	/**
	 * 整数を設定します。
	 * @param bigintDefault 整数
	 */
	public void setBigintDefault(Long bigintDefault) {
		modifiedPropertySet.add("bigintDefault");
		this.bigintDefault = bigintDefault;
	}

	/**
	 * 文字列を返します。
	 * @return 文字列
	 */
	@org.seasar.dao.annotation.tiger.Column("STRING_DEFAULT")
	public String getStringDefault() {
		return stringDefault;
	}

	/**
	 * 文字列を設定します。
	 * @param stringDefault 文字列
	 */
	public void setStringDefault(String stringDefault) {
		modifiedPropertySet.add("stringDefault");
		this.stringDefault = stringDefault;
	}

	/**
	 * 日時上限を返します。
	 * @return 日時上限
	 */
	@org.seasar.dao.annotation.tiger.Column("DATE_MAX")
	public java.util.Date getDateMax() {
		return dateMax;
	}

	/**
	 * 日時上限を設定します。
	 * @param dateMax 日時上限
	 */
	public void setDateMax(java.util.Date dateMax) {
		modifiedPropertySet.add("dateMax");
		this.dateMax = dateMax;
	}

	/**
	 * 日時下限を返します。
	 * @return 日時下限
	 */
	@org.seasar.dao.annotation.tiger.Column("DATE_MIN")
	public java.util.Date getDateMin() {
		return dateMin;
	}

	/**
	 * 日時下限を設定します。
	 * @param dateMin 日時下限
	 */
	public void setDateMin(java.util.Date dateMin) {
		modifiedPropertySet.add("dateMin");
		this.dateMin = dateMin;
	}

	/**
	 * 日時現在を返します。
	 * @return 日時現在
	 */
	@org.seasar.dao.annotation.tiger.Column("DATE_CUR")
	public java.util.Date getDateCur() {
		return dateCur;
	}

	/**
	 * 日時現在を設定します。
	 * @param dateCur 日時現在
	 */
	public void setDateCur(java.util.Date dateCur) {
		modifiedPropertySet.add("dateCur");
		this.dateCur = dateCur;
	}

	/**
	 * 日時現在を返します。
	 * @return 日時現在
	 */
	@org.seasar.dao.annotation.tiger.Column("DATE_NOW")
	public java.util.Date getDateNow() {
		return dateNow;
	}

	/**
	 * 日時現在を設定します。
	 * @param dateNow 日時現在
	 */
	public void setDateNow(java.util.Date dateNow) {
		modifiedPropertySet.add("dateNow");
		this.dateNow = dateNow;
	}

	/**
	 * 時間上限を返します。
	 * @return 時間上限
	 */
	@org.seasar.dao.annotation.tiger.Column("TIME_MAX")
	public java.sql.Time getTimeMax() {
		return timeMax;
	}

	/**
	 * 時間上限を設定します。
	 * @param timeMax 時間上限
	 */
	public void setTimeMax(java.sql.Time timeMax) {
		modifiedPropertySet.add("timeMax");
		this.timeMax = timeMax;
	}

	/**
	 * 時間下限を返します。
	 * @return 時間下限
	 */
	@org.seasar.dao.annotation.tiger.Column("TIME_MIN")
	public java.sql.Time getTimeMin() {
		return timeMin;
	}

	/**
	 * 時間下限を設定します。
	 * @param timeMin 時間下限
	 */
	public void setTimeMin(java.sql.Time timeMin) {
		modifiedPropertySet.add("timeMin");
		this.timeMin = timeMin;
	}

	/**
	 * 時間現在を返します。
	 * @return 時間現在
	 */
	@org.seasar.dao.annotation.tiger.Column("TIME_CUR")
	public java.sql.Time getTimeCur() {
		return timeCur;
	}

	/**
	 * 時間現在を設定します。
	 * @param timeCur 時間現在
	 */
	public void setTimeCur(java.sql.Time timeCur) {
		modifiedPropertySet.add("timeCur");
		this.timeCur = timeCur;
	}

	/**
	 * 時間現在を返します。
	 * @return 時間現在
	 */
	@org.seasar.dao.annotation.tiger.Column("TIME_NOW")
	public java.sql.Time getTimeNow() {
		return timeNow;
	}

	/**
	 * 時間現在を設定します。
	 * @param timeNow 時間現在
	 */
	public void setTimeNow(java.sql.Time timeNow) {
		modifiedPropertySet.add("timeNow");
		this.timeNow = timeNow;
	}

	/**
	 * タイムスタンプ上限を返します。
	 * @return タイムスタンプ上限
	 */
	@org.seasar.dao.annotation.tiger.Column("TIMESTAMP_MAX")
	public java.sql.Timestamp getTimestampMax() {
		return timestampMax;
	}

	/**
	 * タイムスタンプ上限を設定します。
	 * @param timestampMax タイムスタンプ上限
	 */
	public void setTimestampMax(java.sql.Timestamp timestampMax) {
		modifiedPropertySet.add("timestampMax");
		this.timestampMax = timestampMax;
	}

	/**
	 * タイムスタンプ下限を返します。
	 * @return タイムスタンプ下限
	 */
	@org.seasar.dao.annotation.tiger.Column("TIMESTAMP_MIN")
	public java.sql.Timestamp getTimestampMin() {
		return timestampMin;
	}

	/**
	 * タイムスタンプ下限を設定します。
	 * @param timestampMin タイムスタンプ下限
	 */
	public void setTimestampMin(java.sql.Timestamp timestampMin) {
		modifiedPropertySet.add("timestampMin");
		this.timestampMin = timestampMin;
	}

	/**
	 * タイムスタンプ現在を返します。
	 * @return タイムスタンプ現在
	 */
	@org.seasar.dao.annotation.tiger.Column("TIMESTAMP_CUR")
	public java.sql.Timestamp getTimestampCur() {
		return timestampCur;
	}

	/**
	 * タイムスタンプ現在を設定します。
	 * @param timestampCur タイムスタンプ現在
	 */
	public void setTimestampCur(java.sql.Timestamp timestampCur) {
		modifiedPropertySet.add("timestampCur");
		this.timestampCur = timestampCur;
	}

	/**
	 * タイムスタンプ現在を返します。
	 * @return タイムスタンプ現在
	 */
	@org.seasar.dao.annotation.tiger.Column("TIMESTAMP_NOW")
	public java.sql.Timestamp getTimestampNow() {
		return timestampNow;
	}

	/**
	 * タイムスタンプ現在を設定します。
	 * @param timestampNow タイムスタンプ現在
	 */
	public void setTimestampNow(java.sql.Timestamp timestampNow) {
		modifiedPropertySet.add("timestampNow");
		this.timestampNow = timestampNow;
	}


	/**
	 * setterが呼ばれたプロパティのセットを返します。
	 * @return settterが呼ばれたプロパティのセット
	 */
	public Set<String> getModifiedPropertyNames() {
		return this.modifiedPropertySet;
	}

	public String toString() {
		StringBuilder buff = new StringBuilder("[");
		buff.append("/realDefault=").append(realDefault);
		buff.append("/bigintDefault=").append(bigintDefault);
		buff.append("/stringDefault=").append(stringDefault);
		buff.append("/dateMax=").append(dateMax);
		buff.append("/dateMin=").append(dateMin);
		buff.append("/dateCur=").append(dateCur);
		buff.append("/dateNow=").append(dateNow);
		buff.append("/timeMax=").append(timeMax);
		buff.append("/timeMin=").append(timeMin);
		buff.append("/timeCur=").append(timeCur);
		buff.append("/timeNow=").append(timeNow);
		buff.append("/timestampMax=").append(timestampMax);
		buff.append("/timestampMin=").append(timestampMin);
		buff.append("/timestampCur=").append(timestampCur);
		buff.append("/timestampNow=").append(timestampNow);
		buff.append("]");
		return buff.toString();
	}

}
