/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.seasar.dao.pager.PagerContext;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.impl.BooleanToIntPreparedStatement;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.framework.exception.SQLRuntimeException;

public class PagerStatementFactory
implements StatementFactory {
    protected boolean booleanToInt = false;

    public PreparedStatement createPreparedStatement(Connection con, String sql) {
        Object[] args = PagerContext.getContext().peekArgs();
        PreparedStatement pstmt = null;
        if (PagerContext.isPagerCondition(args)) {
            try {
                pstmt = con.prepareStatement(sql, 1004, 1007);
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e);
            }
            return this.createPreparedStatement(pstmt, sql);
        }
        pstmt = ConnectionUtil.prepareStatement((Connection)con, (String)sql);
        return this.createPreparedStatement(pstmt, sql);
    }

    private PreparedStatement createPreparedStatement(PreparedStatement pstmt, String sql) {
        if (this.booleanToInt) {
            return new BooleanToIntPreparedStatement(pstmt, sql);
        }
        return pstmt;
    }

    public CallableStatement createCallableStatement(Connection con, String sql) {
        return ConnectionUtil.prepareCall((Connection)con, (String)sql);
    }

    public void setBooleanToInt(boolean b) {
        this.booleanToInt = b;
    }
}

