/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.sql.metadata;

import java.sql.ResultSet;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jiemamy.utils.sql.ResultSetUtil;

public class BestRowIdentifierMeta {
    public final Scope scope;
    public final String columnName;
    public final int dataType;
    public final String typeName;
    public final int columnSize;
    public final int bufferLength;
    public final short decimalDigits;
    public final PseudoColumn pseudoColumn;

    public BestRowIdentifierMeta(ResultSet bestRowIdentifier) {
        Validate.notNull((Object)bestRowIdentifier);
        this.scope = Scope.getScope(ResultSetUtil.getValue(Short.TYPE, bestRowIdentifier, "SCOPE", Short.valueOf((short)0)));
        this.columnName = ResultSetUtil.getValue(String.class, bestRowIdentifier, "COLUMN_NAME", null);
        this.dataType = ResultSetUtil.getValue(Integer.TYPE, bestRowIdentifier, "DATA_TYPE", Integer.valueOf(0));
        this.typeName = ResultSetUtil.getValue(String.class, bestRowIdentifier, "TYPE_NAME", null);
        this.columnSize = ResultSetUtil.getValue(Integer.TYPE, bestRowIdentifier, "COLUMN_SIZE", Integer.valueOf(0));
        this.bufferLength = ResultSetUtil.getValue(Integer.TYPE, bestRowIdentifier, "BUFFER_LENGTH", Integer.valueOf(0));
        this.decimalDigits = ResultSetUtil.getValue(Short.TYPE, bestRowIdentifier, "DECIMAL_DIGITS", Short.valueOf((short)0));
        this.pseudoColumn = PseudoColumn.getPseudoColumn(ResultSetUtil.getValue(Short.TYPE, bestRowIdentifier, "PSEUDO_COLUMN", Short.valueOf((short)0)));
        assert (this.scope != null);
        assert (this.columnName != null);
        assert (this.typeName != null);
        assert (this.pseudoColumn != null);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Scope {
        TEMPORARY(0),
        TRANSACTION(1),
        SESSION(2);

        private int value;

        private static Scope getScope(short value) {
            for (Scope scope : Scope.values()) {
                if (scope.value != value) continue;
                return scope;
            }
            return null;
        }

        private Scope(int value) {
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PseudoColumn {
        UNKNOWN(0),
        NOT_PSEUDO(1),
        PSEUDO(2);

        private int value;

        private static PseudoColumn getPseudoColumn(short value) {
            for (PseudoColumn pseudoColumn : PseudoColumn.values()) {
                if (pseudoColumn.value != value) continue;
                return pseudoColumn;
            }
            return null;
        }

        private PseudoColumn(int value) {
            this.value = value;
        }
    }
}

