/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.entity;

import java.util.Set;
import java.util.HashSet;

/**
 * DEPT_TABLEテーブルのEntityです。
 * @author S2Dao-CodeGen
 */

@org.seasar.dao.annotation.tiger.Bean(table = "DEPT_TABLE", versionNoProperty = "versionno")
public abstract class AbstractDeptTable {

	private Integer deptId;
	private String dname;
	private String loc;
	private Integer versionno;
	private Boolean active;
	
	private Set<String> modifiedPropertySet = new HashSet<String>();

	/**
	 * 部署番号を返します。
	 * @return 部署番号
	 */
	@org.seasar.dao.annotation.tiger.Id(value = org.seasar.dao.annotation.tiger.IdType.IDENTITY)
		@org.seasar.dao.annotation.tiger.Column("DEPT_ID")
	public Integer getDeptId() {
		return deptId;
	}

	/**
	 * 部署番号を設定します。
	 * @param deptId 部署番号
	 */
	public void setDeptId(Integer deptId) {
		modifiedPropertySet.add("deptId");
		this.deptId = deptId;
	}

	/**
	 * 部署名を返します。
	 * @return 部署名
	 */
	@org.seasar.dao.annotation.tiger.Column("DNAME")
	public String getDname() {
		return dname;
	}

	/**
	 * 部署名を設定します。
	 * @param dname 部署名
	 */
	public void setDname(String dname) {
		modifiedPropertySet.add("dname");
		this.dname = dname;
	}

	/**
	 * 位置を返します。
	 * @return 位置
	 */
	@org.seasar.dao.annotation.tiger.Column("LOC")
	public String getLoc() {
		return loc;
	}

	/**
	 * 位置を設定します。
	 * @param loc 位置
	 */
	public void setLoc(String loc) {
		modifiedPropertySet.add("loc");
		this.loc = loc;
	}

	/**
	 * バージョン番号を返します。
	 * @return バージョン番号
	 */
	@org.seasar.dao.annotation.tiger.Column("VERSIONNO")
	public Integer getVersionno() {
		return versionno;
	}

	/**
	 * バージョン番号を設定します。
	 * @param versionno バージョン番号
	 */
	public void setVersionno(Integer versionno) {
		modifiedPropertySet.add("versionno");
		this.versionno = versionno;
	}

	/**
	 * 状態を返します。
	 * @return 状態
	 */
	@org.seasar.dao.annotation.tiger.Column("ACTIVE")
	public Boolean getActive() {
		return active;
	}

	/**
	 * 状態を設定します。
	 * @param active 状態
	 */
	public void setActive(Boolean active) {
		modifiedPropertySet.add("active");
		this.active = active;
	}


	/**
	 * setterが呼ばれたプロパティのセットを返します。
	 * @return settterが呼ばれたプロパティのセット
	 */
	public Set<String> getModifiedPropertyNames() {
		return this.modifiedPropertySet;
	}

	public String toString() {
		StringBuilder buff = new StringBuilder("[");
		buff.append("/deptId=").append(deptId);
		buff.append("/dname=").append(dname);
		buff.append("/loc=").append(loc);
		buff.append("/versionno=").append(versionno);
		buff.append("/active=").append(active);
		buff.append("]");
		return buff.toString();
	}

}
