/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dialect.postgresql;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dialect.DefaultSqlEmitter;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.dialect.TokenResolver;
import org.jiemamy.dialect.postgresql.experimental.parameter.IndexMethodType;
import org.jiemamy.dialect.postgresql.experimental.parameter.IndexOption;
import org.jiemamy.dialect.postgresql.experimental.parameter.SimpleIndexOption;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.index.JmIndex;
import org.jiemamy.model.index.JmIndexColumn;
import org.jiemamy.model.sql.Identifier;
import org.jiemamy.model.sql.Keyword;
import org.jiemamy.model.sql.Literal;
import org.jiemamy.model.sql.Separator;
import org.jiemamy.model.sql.SimpleSqlStatement;
import org.jiemamy.model.sql.SqlStatement;
import org.jiemamy.model.table.JmTable;

public class PostgreSqlEmitter
extends DefaultSqlEmitter {
    public PostgreSqlEmitter(Dialect dialect) {
        super(dialect);
    }

    public PostgreSqlEmitter(Dialect dialect, TokenResolver tokenResolver) {
        super(dialect, tokenResolver);
    }

    protected SqlStatement emitCreateIndexStatement(JiemamyContext context, JmTable table, JmIndex index) {
        IndexOption indexOption = (IndexOption)index.getParam(SimpleIndexOption.KEY);
        if (indexOption == null) {
            return super.emitCreateIndexStatement(context, table, index);
        }
        ArrayList tokens = Lists.newArrayList();
        tokens.add(Keyword.CREATE);
        if (index.isUnique()) {
            tokens.add(Keyword.UNIQUE);
        }
        tokens.add(Keyword.INDEX);
        if (indexOption.getConcurrently() != null && indexOption.getConcurrently().booleanValue()) {
            tokens.add(Keyword.of((String)"CONCURRENTLY"));
        }
        tokens.add(Identifier.of((String)index.getName()));
        tokens.add(Keyword.ON);
        tokens.add(Identifier.of((String)table.getName()));
        if (indexOption.getIndexMethodType() != null) {
            IndexMethodType indexMethodType = indexOption.getIndexMethodType();
            tokens.add(Keyword.of((String)"USING"));
            tokens.add(Identifier.of((String)((Object)indexMethodType).toString()));
        }
        tokens.add(Separator.LEFT_PAREN);
        for (JmIndexColumn indexColumn : index.getIndexColumns()) {
            tokens.addAll(this.emitIndexColumnClause(context, indexColumn));
        }
        if (!index.getIndexColumns().isEmpty()) {
            tokens.remove(tokens.size() - 1);
        }
        tokens.add(Separator.RIGHT_PAREN);
        if (indexOption.getFillfactor() != null) {
            tokens.add(Keyword.WITH);
            tokens.add(Separator.LEFT_PAREN);
            tokens.add(Identifier.of((String)"fillfactor"));
            tokens.add(Separator.EQUAL);
            tokens.add(Literal.of((Number)indexOption.getFillfactor()));
            tokens.add(Separator.RIGHT_PAREN);
        }
        if (indexOption.getTablespace() != null) {
            tokens.add(Keyword.of((String)"TABLESPACE"));
            tokens.add(Identifier.of((String)indexOption.getTablespace()));
        }
        if (indexOption.getPredicate() != null) {
            tokens.add(Keyword.WHERE);
            tokens.add(Identifier.of((String)indexOption.getPredicate()));
        }
        tokens.add(Separator.SEMICOLON);
        return new SimpleSqlStatement((List)tokens);
    }

    protected SqlStatement emitDropDbObjectStatement(DbObject dbObject) {
        SqlStatement stmt = super.emitDropDbObjectStatement(dbObject);
        return this.insertIfExists(stmt);
    }

    protected SqlStatement emitDropIndexStatement(JmIndex index) {
        SqlStatement stmt = super.emitDropIndexStatement(index);
        return this.insertIfExists(stmt);
    }

    protected SqlStatement emitDropSchemaStatement(String schemaName) {
        SqlStatement stmt = super.emitDropSchemaStatement(schemaName);
        return this.insertIfExists(stmt);
    }

    private SqlStatement insertIfExists(SqlStatement stmt) {
        List tokens = stmt.toTokens();
        return new SimpleSqlStatement(tokens);
    }
}

