/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.types;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.dao.types.BytesType;
import org.seasar.framework.exception.SSQLException;

public class SerializableType
extends BytesType {
    public SerializableType(BytesType.Trait trait) {
        super(trait);
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return this.deserialize(super.getValue(resultSet, index));
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return this.deserialize(super.getValue(resultSet, columnName));
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return this.deserialize(super.getValue(cs, index));
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return this.deserialize(super.getValue(cs, parameterName));
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        super.bindValue(ps, index, (Object)this.serialize(value));
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        super.bindValue(cs, parameterName, (Object)this.serialize(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] serialize(Object o) throws SQLException {
        byte[] byArray;
        if (o == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        try {
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                oos.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new SSQLException("EDAO0034", new Object[]{e}, (Throwable)e);
            }
        }
        oos.close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object deserialize(Object bytes) throws SQLException {
        Object object;
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream((byte[])bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            object = ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                ois.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new SSQLException("EDAO0034", new Object[]{e}, (Throwable)e);
            }
        }
        ois.close();
        return object;
    }
}

