/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import javax.sql.DataSource;
import org.seasar.dao.CommandContext;
import org.seasar.dao.impl.AbstractDynamicCommand;
import org.seasar.dao.pager.PagingSqlRewriter;
import org.seasar.extension.jdbc.ResultSetFactory;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.impl.BasicHandler;
import org.seasar.extension.jdbc.impl.BasicSelectHandler;

public class SelectDynamicCommand
extends AbstractDynamicCommand {
    private ResultSetHandler resultSetHandler;
    private ResultSetFactory resultSetFactory;
    private PagingSqlRewriter pagingSqlRewriter;

    public SelectDynamicCommand(DataSource dataSource, StatementFactory statementFactory, ResultSetHandler resultSetHandler, ResultSetFactory resultSetFactory, PagingSqlRewriter pagingSqlRewriter) {
        super(dataSource, statementFactory);
        this.resultSetHandler = resultSetHandler;
        this.resultSetFactory = resultSetFactory;
        this.pagingSqlRewriter = pagingSqlRewriter;
    }

    public ResultSetHandler getResultSetHandler() {
        return this.resultSetHandler;
    }

    public Object execute(Object[] args) {
        CommandContext ctx = this.apply(args);
        Object[] bindVariables = ctx.getBindVariables();
        Class[] bindVariableTypes = ctx.getBindVariableTypes();
        String sql = ctx.getSql();
        String executingSql = this.pagingSqlRewriter.rewrite(sql, bindVariables, bindVariableTypes);
        BasicSelectHandler selectHandler = new BasicSelectHandler(this.getDataSource(), executingSql, this.resultSetHandler, this.getStatementFactory(), this.resultSetFactory);
        this.injectDaoClass((BasicHandler)selectHandler);
        selectHandler.setFetchSize(-1);
        Object ret = selectHandler.execute(ctx.getBindVariables(), ctx.getBindVariableTypes());
        this.pagingSqlRewriter.setCount(sql, args, bindVariables, bindVariableTypes);
        return ret;
    }
}

