/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.util.HashMap;
import java.util.Map;
import org.seasar.dao.AnnotationReaderFactory;
import org.seasar.dao.BeanAnnotationReader;
import org.seasar.dao.DtoMetaData;
import org.seasar.dao.DtoMetaDataFactory;
import org.seasar.dao.PropertyTypeFactory;
import org.seasar.dao.PropertyTypeFactoryBuilder;
import org.seasar.dao.impl.DtoMetaDataImpl;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;

public class DtoMetaDataFactoryImpl
implements DtoMetaDataFactory,
Disposable {
    public static final String annotationReaderFactory_BINDING = "bindingType=must";
    public static final String propertyTypeFactoryBuilder_BINDING = "bindingType=must";
    protected AnnotationReaderFactory annotationReaderFactory;
    protected PropertyTypeFactoryBuilder propertyTypeFactoryBuilder;
    private Map cache = new HashMap(100);
    protected boolean initialized = false;

    public AnnotationReaderFactory getAnnotationReaderFactory() {
        return this.annotationReaderFactory;
    }

    public void setAnnotationReaderFactory(AnnotationReaderFactory annotationReaderFactory) {
        this.annotationReaderFactory = annotationReaderFactory;
    }

    public void setPropertyTypeFactoryBuilder(PropertyTypeFactoryBuilder propertyTypeFactoryBuilder) {
        this.propertyTypeFactoryBuilder = propertyTypeFactoryBuilder;
    }

    public synchronized DtoMetaData getDtoMetaData(Class dtoClass) {
        String key;
        DtoMetaDataImpl dmd;
        if (!this.initialized) {
            DisposableUtil.add((Disposable)this);
            this.initialized = true;
        }
        if ((dmd = (DtoMetaDataImpl)this.cache.get(key = dtoClass.getName())) != null) {
            return dmd;
        }
        BeanAnnotationReader reader = this.annotationReaderFactory.createBeanAnnotationReader(dtoClass);
        PropertyTypeFactory propertyTypeFactory = this.createPropertyTypeFactory(dtoClass, reader);
        dmd = new DtoMetaDataImpl();
        dmd.setBeanClass(dtoClass);
        dmd.setBeanAnnotationReader(reader);
        dmd.setPropertyTypeFactory(propertyTypeFactory);
        dmd.initialize();
        this.cache.put(key, dmd);
        return dmd;
    }

    public synchronized void dispose() {
        this.cache.clear();
        this.initialized = false;
    }

    protected PropertyTypeFactory createPropertyTypeFactory(Class dtoClass, BeanAnnotationReader beanAnnotationReader) {
        return this.propertyTypeFactoryBuilder.build(dtoClass, beanAnnotationReader);
    }
}

