/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.lib;

import java.util.Date;

/**
 * 日付に対する検索条件のインターフェース
 * 
 * @author azusa
 * 
 */
public interface DateConditionElement<T> extends ConditionElement<T> {

    /**
     * 日付に対する「～日から」の検索条件を設定します。 メソッド内部で時分秒以下は切り捨てます。
     * 
     * @param from
     *            検索条件の日付
     */
    void dateFrom(Date from);

    /**
     * 日付に対する「～日まで」の検索条件を設定します。 メソッド内部で時分秒は切り上げます。 (例えば2/17を指定した場合、2/18
     * 0:00:00になります。)
     * 
     * @param to
     *            検索条件の日付
     */
    void dateTo(Date to);

    /**
     * 日付に対する「～日から～日まで」の検索条件を設定します。 メソッド内部で「から」の条件の時分秒は切捨て、「まで」の条件は切り上げます。
     * (例えば「まで」の条件に2/17を指定した場合、2/18 0:00:00になります。)
     * 
     * @param from
     *            「から」の条件
     * @param to
     *            「まで」の条件
     */
    void dateFromTo(Date from, Date to);

}
