/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.lib.internal.impl;

import java.sql.DatabaseMetaData;

import org.seasar.dao.BeanAnnotationReader;
import org.seasar.dao.ColumnNaming;
import org.seasar.dao.DaoNamingConvention;
import org.seasar.dao.Dbms;
import org.seasar.dao.PropertyTypeFactory;
import org.seasar.dao.ValueTypeFactory;
import org.seasar.dao.impl.DaoMetaDataFactoryImpl;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.impl.FastPropertyTypeFactory;
import org.seasar.dao.impl.FastPropertyTypeFactoryBuilder;
import org.seasar.extension.jdbc.PropertyType;

/**
 * S2Dao-CodeGenで使うDaoMetaDataFactoryです。
 */
@SuppressWarnings("unchecked")
public class CodeGenDaoMetaDataFactoryImpl extends DaoMetaDataFactoryImpl {

    protected DaoMetaDataImpl createDaoMetaDataImpl() {
        return new CodeGenDaoMetaDataImpl();
    }

    /**
     * S2Dao-CodeGen用のFastPropertyTypeFactoryBuilderです。
     * 
     * @author azusa
     * 
     */
    public static class CodeGenFastPropertyTypeFactoryBuilder extends FastPropertyTypeFactoryBuilder {

        /**
         * コンストラクタです。
         */
        public CodeGenFastPropertyTypeFactoryBuilder() {
            super();
        }

        public PropertyTypeFactory build(Class beanClass, BeanAnnotationReader beanAnnotationReader) {

            return new CodeGenFastPropertyTypeFactory(beanClass, beanAnnotationReader, valueTypeFactory, columnNaming);
        }

        public PropertyTypeFactory build(Class beanClass, BeanAnnotationReader beanAnnotationReader, Dbms dbms,
                DatabaseMetaData databaseMetaData) {

            return new CodeGenFastPropertyTypeFactory(beanClass, beanAnnotationReader, valueTypeFactory, columnNaming,
                    daoNamingConvention, dbms);
        }

    }

    /**
     * S2Dao-CodeGen用のFastPropertyTypeFactoryです。 Entityのプロパティに<a
     * href="http://s2dao.seasar.org/ja/s2dao.html#ColumnAnnotation"
     * >Columnアノテーション</a>がついている場合のみ永続化の対象とします。
     * 
     * @author azusa
     * 
     */
    public static class CodeGenFastPropertyTypeFactory extends FastPropertyTypeFactory {

        /**
         * コンストラクタです。 基底クラスに委譲します。
         * 
         * @param beanClass
         * @param beanAnnotationReader
         * @param valueTypeFactory
         * @param columnNaming
         */
        public CodeGenFastPropertyTypeFactory(Class beanClass, BeanAnnotationReader beanAnnotationReader,
                ValueTypeFactory valueTypeFactory, ColumnNaming columnNaming) {
            super(beanClass, beanAnnotationReader, valueTypeFactory, columnNaming);
        }

        /**
         * コンストラクタです。 基底クラスに委譲します。
         * 
         * @param beanClass
         * @param beanAnnotationReader
         * @param valueTypeFactory
         * @param columnNaming
         * @param daoNamingConvention
         * @param dbms
         */
        public CodeGenFastPropertyTypeFactory(Class beanClass, BeanAnnotationReader beanAnnotationReader,
                ValueTypeFactory valueTypeFactory, ColumnNaming columnNaming, DaoNamingConvention daoNamingConvention,
                Dbms dbms) {
            super(beanClass, beanAnnotationReader, valueTypeFactory, columnNaming, daoNamingConvention, dbms);
        }

        protected boolean isPersistent(PropertyType propertyType) {
            return beanAnnotationReader.getColumnAnnotation(propertyType.getPropertyDesc()) != null;
        }

    }

}
