/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.lib;

/**
 * SQLの条件のカラム名を指定するインターフェースです。
 * 
 * @author azusa
 * 
 */
public interface Column {

    /**
     * SQLの別名を返します。
     * 
     * @return SQLの別名
     */
    String getAlias();

    /**
     * 列の名前を返します。
     * 
     * @return 列の名前
     */
    String getName();

    /**
     * 検索条件のクラスを返します。
     * 
     * @return 検索条件のクラス
     */
    Class<? extends Condition> getCodnitionClass();
}
