/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.lib.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.seasar.codegen.lib.BindValue;
import org.seasar.codegen.lib.Column;
import org.seasar.codegen.lib.ConditionResult;
import org.seasar.codegen.lib.Order;
import org.seasar.codegen.lib.Query;
import org.seasar.codegen.lib.impl.OrderImpl;
import org.seasar.codegen.lib.impl.QueryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionResultImpl
implements ConditionResult {
    private List<Order> orderList = new ArrayList<Order>();
    private List<BindValue> bindValues = new ArrayList<BindValue>();
    private Query query = new NullQuery();

    @Override
    public void addOrder(Column column, boolean asc) {
        this.orderList.add(new OrderImpl(column, asc));
    }

    @Override
    public void addQuery(String query, Object ... args) {
        this.query = new QueryImpl(query, args);
    }

    @Override
    public List<BindValue> getBindValues() {
        return this.bindValues;
    }

    @Override
    public List<Order> getOrderList() {
        return this.orderList;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (BindValue bindValue : this.bindValues) {
            sb.append("/");
            sb.append(bindValue);
        }
        if (!this.orderList.isEmpty()) {
            sb.append("/ORDER BY ");
        }
        Iterator<Order> i = this.orderList.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public void addBindValue(BindValue bindValue) {
        this.bindValues.add(bindValue);
    }

    private static class NullQuery
    implements Query {
        private static final Object[] EMPTY = new Object[0];

        private NullQuery() {
        }

        public Object[] getArgs() {
            return EMPTY;
        }

        public String getQuery() {
            return "";
        }

        public String toString() {
            return "";
        }
    }
}

