/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.lib;

import org.seasar.dao.pager.PagerCondition;

/**
 * Daoの引数に取る検索条件です。
 * 
 * @author azusa
 * 
 */
public interface Condition extends PagerCondition {

    /**
     * 検索条件の組み立て結果を返します。
     * 
     * @return 検索条件の組み立て結果
     */
    ConditionResult getConditionResult();

    /**
     * SQL文を追加します。
     * 
     * @param query
     *            SQL文
     * @param args
     *            引数
     */
    void addQuery(String query, Object... args);

}
