/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.lib.impl;

import org.seasar.codegen.lib.Query;

/**
 * @author azusa
 * 
 */
public class QueryImpl implements Query {

    /**
     * コンストラクタ
     * 
     * @param query
     *            クエリー文
     * @param args
     *            引数
     */
    public QueryImpl(String query, Object[] args) {
        super();
        this.query = query;
        this.args = args;
    }

    public String getQuery() {
        return query;
    }

    public Object[] getArgs() {
        return args;
    }

    private String query;

    private Object[] args;

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(query);
        if (args.length != 0) {
            sb.append("(");
            for (int i = 0; i < args.length; i++) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(args[i]);
            }

            sb.append(")");
        }
        return sb.toString();
    }

}
