/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.unit;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.seasar.aptina.commons.util.CollectionUtils;
import org.seasar.aptina.commons.util.IOUtils;
import org.seasar.aptina.unit.InMemoryJavaFileObject;

class TestingJavaFileManager
extends ForwardingJavaFileManager<StandardJavaFileManager> {
    final Map<String, InMemoryJavaFileObject> fileObjects = CollectionUtils.newHashMap();
    final Map<String, InMemoryJavaFileObject> javaFileObjects = CollectionUtils.newHashMap();
    final Charset charset;

    public TestingJavaFileManager(StandardJavaFileManager fileManager, Charset charset) {
        super(fileManager);
        this.charset = charset;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        if (relativeName.endsWith(".java")) {
            return this.getJavaFileForInput(location, packageName + "." + relativeName, JavaFileObject.Kind.SOURCE);
        }
        if (relativeName.endsWith(".class")) {
            return this.getJavaFileForInput(location, packageName + "." + relativeName, JavaFileObject.Kind.CLASS);
        }
        String key = this.createKey(packageName, relativeName);
        if (this.fileObjects.containsKey(key)) {
            return this.fileObjects.get(key);
        }
        return super.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        if (relativeName.endsWith(".java")) {
            return this.getJavaFileForOutput(location, packageName + "." + relativeName, JavaFileObject.Kind.SOURCE, sibling);
        }
        if (relativeName.endsWith(".class")) {
            return this.getJavaFileForOutput(location, packageName + "." + relativeName, JavaFileObject.Kind.CLASS, sibling);
        }
        String key = this.createKey(packageName, relativeName);
        if (this.fileObjects.containsKey(key)) {
            return this.fileObjects.get(key);
        }
        byte[] content = null;
        URI uri = null;
        try {
            FileObject originalFileObject = null;
            if (location == StandardLocation.CLASS_OUTPUT) {
                originalFileObject = super.getFileForInput(StandardLocation.SOURCE_PATH, packageName, relativeName);
            }
            if (originalFileObject == null) {
                originalFileObject = super.getFileForOutput(location, packageName, relativeName, sibling);
            }
            uri = originalFileObject.toUri();
            content = IOUtils.readBytes((InputStream)originalFileObject.openInputStream());
        }
        catch (FileNotFoundException originalFileObject) {
            // empty catch block
        }
        InMemoryJavaFileObject fileObject = new InMemoryJavaFileObject(uri != null ? uri : this.toURI(location, packageName, relativeName), JavaFileObject.Kind.OTHER, this.charset, content);
        this.fileObjects.put(key, fileObject);
        return fileObject;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        String key = this.createKey(className, kind);
        if (this.fileObjects.containsKey(key)) {
            return this.fileObjects.get(key);
        }
        return super.getJavaFileForInput(location, className, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        String key = this.createKey(className, kind);
        if (this.fileObjects.containsKey(key)) {
            return this.fileObjects.get(key);
        }
        byte[] content = null;
        URI uri = null;
        try {
            JavaFileObject originalFileObject = super.getJavaFileForOutput(location, className, kind, sibling);
            uri = originalFileObject.toUri();
            content = IOUtils.readBytes((InputStream)originalFileObject.openInputStream());
        }
        catch (FileNotFoundException originalFileObject) {
            // empty catch block
        }
        InMemoryJavaFileObject fileObject = new InMemoryJavaFileObject(uri != null ? uri : this.toURI(location, className), kind, this.charset, content);
        this.fileObjects.put(key, fileObject);
        return fileObject;
    }

    @Override
    public boolean isSameFile(FileObject lhs, FileObject rhs) {
        if (lhs instanceof InMemoryJavaFileObject) {
            if (rhs instanceof InMemoryJavaFileObject) {
                return lhs == rhs;
            }
            return false;
        }
        return super.isSameFile(lhs, rhs);
    }

    public JavaFileObject getGeneratedJavaFile(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        String key = kind.name() + "::" + className;
        if (this.fileObjects.containsKey(key)) {
            return this.fileObjects.get(key);
        }
        return null;
    }

    URI toURI(JavaFileManager.Location location, String packageName, String relativeName) {
        try {
            return new URI(location.getName() + "/" + packageName.replace('.', '/') + "/" + relativeName);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    URI toURI(JavaFileManager.Location location, String className) {
        try {
            return new URI(location.getName() + "/" + className.replace('.', '/') + ".java");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    String createKey(String packageName, String relativeName) {
        if (packageName == null || packageName.isEmpty()) {
            return relativeName;
        }
        return packageName.replace('.', '/') + "/" + relativeName;
    }

    String createKey(String className, JavaFileObject.Kind kind) {
        return className.replace('.', '/') + kind.extension;
    }
}

