/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.commons.util;

import java.util.Iterator;

public class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence s) {
        return !StringUtils.isEmpty(s);
    }

    public static String capitalize(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String decapitalize(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (s.length() == 1) {
            return s.toLowerCase();
        }
        if (Character.isUpperCase(s.charAt(0)) && Character.isUpperCase(s.charAt(1))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String join(Iterable<? extends CharSequence> elements, String separator) {
        StringBuilder buf = new StringBuilder();
        for (CharSequence charSequence : elements) {
            buf.append(charSequence).append(separator);
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - separator.length());
        }
        return new String(buf);
    }

    public static String join(Iterable<? extends CharSequence> elements1, Iterable<? extends CharSequence> elements2, String separator1, String separator2) {
        StringBuilder buf = new StringBuilder();
        Iterator<? extends CharSequence> it = elements2.iterator();
        for (CharSequence charSequence : elements1) {
            if (!it.hasNext()) {
                throw new IllegalArgumentException("elements1 > elements2");
            }
            CharSequence element2 = it.next();
            buf.append(charSequence).append(separator1).append(element2).append(separator2);
        }
        if (it.hasNext()) {
            throw new IllegalArgumentException("elements1 < elements2");
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - separator2.length());
        }
        return new String(buf);
    }
}

