/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.beans.internal;

import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.seasar.aptina.beans.internal.BeanClassGenerator;
import org.seasar.aptina.beans.internal.BeanInfo;
import org.seasar.aptina.beans.internal.BeanInfoFactory;
import org.seasar.aptina.beans.internal.DiagnosticMessageCode;
import org.seasar.aptina.commons.message.EnumMessageFormatter;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"org.seasar.aptina.beans.BeanState"})
public class BeansProcessor
extends AbstractProcessor {
    protected EnumMessageFormatter<DiagnosticMessageCode> messageFormatter;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.messageFormatter = new EnumMessageFormatter<DiagnosticMessageCode>(DiagnosticMessageCode.class, this.processingEnv.getLocale());
        BeanInfoFactory beanMetaFactory = new BeanInfoFactory(this.processingEnv);
        BeanClassGenerator beanClassGenerator = new BeanClassGenerator(this.processingEnv);
        for (TypeElement typeElement : annotations) {
            for (TypeElement typeElement2 : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(typeElement))) {
                BeanInfo beanInfo = beanMetaFactory.createBeanInfo(typeElement2);
                if (beanInfo == null) continue;
                try {
                    beanClassGenerator.generateAndWrite(beanInfo, typeElement2);
                }
                catch (IOException e) {
                    this.printMessage(typeElement2, DiagnosticMessageCode.APT0000, e);
                }
            }
        }
        return false;
    }

    protected void printMessage(Element element, DiagnosticMessageCode messageCode, Object ... args) {
        this.processingEnv.getMessager().printMessage(messageCode.getKind(), this.messageFormatter.getMessage(messageCode, args), element);
    }
}

