/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.unit;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementScanner6;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"*"})
public class PrintingProcessor
extends AbstractProcessor {
    protected static final char[] SPACES = new char[100];
    protected PrintWriter out;
    protected int depth;

    public PrintingProcessor() {
        this(new PrintWriter(System.out));
    }

    public PrintingProcessor(PrintWriter out) {
        this.out = out;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getRootElements()) {
            new PrintingVisitor().scan(element);
        }
        return false;
    }

    protected void printEnterMessage(Element e) {
        String comment = this.processingEnv.getElementUtils().getDocComment(e);
        if (comment != null) {
            this.indent(this.depth * 2);
            this.out.println("/**");
            BufferedReader reader = new BufferedReader(new StringReader(comment));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    this.indent(this.depth * 2);
                    this.out.print(" * ");
                    this.out.println(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.indent(this.depth * 2);
            this.out.println(" */");
        }
        this.indent(this.depth * 2);
        this.out.print(e.getKind().name());
        this.out.print(' ');
        this.out.print(e);
        this.out.println(" {");
    }

    protected void printLeaveMessage(Element e) {
        this.indent(this.depth * 2);
        this.out.println("}");
    }

    protected void indent(int depth) {
        for (int i = depth; i > 0; i -= SPACES.length) {
            this.out.write(SPACES, 0, i > SPACES.length ? SPACES.length : i);
        }
    }

    static {
        Arrays.fill(SPACES, ' ');
    }

    class PrintingVisitor
    extends ElementScanner6<Void, Void> {
        PrintingVisitor() {
        }

        @Override
        public Void visitPackage(PackageElement e, Void p) {
            this.enter(e);
            super.visitPackage(e, p);
            this.leave(e);
            return null;
        }

        @Override
        public Void visitType(TypeElement e, Void p) {
            this.enter(e);
            super.visitType(e, p);
            this.leave(e);
            return null;
        }

        @Override
        public Void visitVariable(VariableElement e, Void p) {
            this.enter(e);
            super.visitVariable(e, p);
            this.leave(e);
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableElement e, Void p) {
            this.enter(e);
            super.visitExecutable(e, p);
            this.leave(e);
            return null;
        }

        @Override
        public Void visitTypeParameter(TypeParameterElement e, Void p) {
            this.enter(e);
            super.visitTypeParameter(e, p);
            this.leave(e);
            return null;
        }

        void enter(Element e) {
            PrintingProcessor.this.printEnterMessage(e);
            PrintingProcessor.this.out.flush();
            ++PrintingProcessor.this.depth;
        }

        void leave(Element e) {
            --PrintingProcessor.this.depth;
            PrintingProcessor.this.printLeaveMessage(e);
            PrintingProcessor.this.out.flush();
        }
    }
}

