/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.struts.exception;

import org.seasar.framework.exception.SRuntimeException;

/**
 * ユーザに必要な権限がない場合の例外です。
 * 
 * @author higa
 * 
 */
public class NoRoleRuntimeException extends SRuntimeException {

    private static final long serialVersionUID = 1L;

    private String user;

    /**
     * インスタンスを構築します。
     * 
     * @param user
     *            ユーザ
     * 
     */
    public NoRoleRuntimeException(String user) {
        super("ESAS0008", new Object[] { user });
        this.user = user;
    }

    /**
     * ユーザを返します。
     * 
     * @return ユーザ
     */
    public String getUser() {
        return user;
    }
}