/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.config;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.config.S2ActionMapping;
import org.seasar.struts.config.S2ValidationConfig;
import org.seasar.struts.enums.SaveType;
import org.seasar.struts.exception.IllegalInputPatternRuntimeException;
import org.seasar.struts.exception.IllegalUrlPatternRuntimeException;
import org.seasar.struts.util.URLEncoderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2ExecuteConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String METHOD_NAME = "SAStruts.method";
    protected Method method;
    protected List<S2ValidationConfig> validationConfigs;
    protected SaveType saveErrors = SaveType.REQUEST;
    protected String input;
    protected List<String> inputParamNames = new ArrayList<String>();
    protected String urlPattern;
    protected Pattern urlPatternRegexp;
    protected boolean urlPatternAllSelected = false;
    protected List<String> urlParamNames = new ArrayList<String>();
    protected String[] roles;
    protected boolean stopOnValidationError = true;
    protected boolean removeActionForm = false;
    protected Method resetMethod;
    protected boolean redirect = false;

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
        this.setUrlPattern(method.getName());
    }

    public boolean isValidator() {
        if (this.validationConfigs != null) {
            for (S2ValidationConfig cfg : this.validationConfigs) {
                if (!cfg.isValidator()) continue;
                return true;
            }
        }
        return false;
    }

    public List<S2ValidationConfig> getValidationConfigs() {
        return this.validationConfigs;
    }

    public void setValidationConfigs(List<S2ValidationConfig> validationConfigs) {
        this.validationConfigs = validationConfigs;
    }

    public SaveType getSaveErrors() {
        return this.saveErrors;
    }

    public void setSaveErrors(SaveType saveErrors) {
        this.saveErrors = saveErrors;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
        if (StringUtil.isEmpty((String)input)) {
            return;
        }
        char[] chars = input.toCharArray();
        int length = chars.length;
        int index = -1;
        for (int i = 0; i < length; ++i) {
            if (chars[i] == '{') {
                index = i;
                continue;
            }
            if (chars[i] != '}') continue;
            if (index >= 0) {
                this.inputParamNames.add(input.substring(index + 1, i));
                index = -1;
                continue;
            }
            throw new IllegalInputPatternRuntimeException(input);
        }
        if (index >= 0) {
            throw new IllegalInputPatternRuntimeException(input);
        }
    }

    public String resolveInput(S2ActionMapping actionMapping) {
        String s = this.input;
        for (String name : this.inputParamNames) {
            s = s.replace("{" + name + "}", actionMapping.getPropertyAsString(name));
        }
        return s;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        if (StringUtil.isEmpty((String)urlPattern)) {
            return;
        }
        this.urlPattern = urlPattern;
        StringBuilder sb = new StringBuilder(50);
        char[] chars = urlPattern.toCharArray();
        int length = chars.length;
        int index = -1;
        for (int i = 0; i < length; ++i) {
            if (chars[i] == '{') {
                index = i;
                continue;
            }
            if (chars[i] == '}') {
                if (index >= 0) {
                    sb.append("([^/]+)");
                    this.urlParamNames.add(urlPattern.substring(index + 1, i));
                    index = -1;
                    continue;
                }
                throw new IllegalUrlPatternRuntimeException(urlPattern);
            }
            if (index >= 0) continue;
            sb.append(chars[i]);
        }
        if (index >= 0) {
            throw new IllegalUrlPatternRuntimeException(urlPattern);
        }
        String pattern = sb.toString();
        this.urlPatternAllSelected = pattern.equals("([^/]+)");
        this.urlPatternRegexp = Pattern.compile("^" + pattern + "$");
    }

    public boolean isUrlPatternAllSelected() {
        return this.urlPatternAllSelected;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public void setRoles(String[] roles) {
        this.roles = roles;
    }

    public boolean isStopOnValidationError() {
        return this.stopOnValidationError;
    }

    public void setStopOnValidationError(boolean stopOnValidationError) {
        this.stopOnValidationError = stopOnValidationError;
    }

    public boolean isRemoveActionForm() {
        return this.removeActionForm;
    }

    public void setRemoveActionForm(boolean removeActionForm) {
        this.removeActionForm = removeActionForm;
    }

    public Method getResetMethod() {
        return this.resetMethod;
    }

    public void setResetMethod(Method resetMethod) {
        this.resetMethod = resetMethod;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public void setRedirect(boolean redirect) {
        this.redirect = redirect;
    }

    public boolean isTarget(String paramPath) {
        if (!StringUtil.isEmpty((String)paramPath)) {
            return this.urlPatternRegexp.matcher(paramPath).find();
        }
        return false;
    }

    public boolean isTarget(HttpServletRequest request) {
        String methodName = request.getParameter(METHOD_NAME);
        if (!StringUtil.isEmpty((String)methodName)) {
            return methodName.equals(this.method.getName());
        }
        return !StringUtil.isEmpty((String)request.getParameter(this.method.getName())) || !StringUtil.isEmpty((String)request.getParameter(this.method.getName() + ".x")) || !StringUtil.isEmpty((String)request.getParameter(this.method.getName() + ".y"));
    }

    public String getQueryString(String paramPath) {
        String urlEncodedMethodName = URLEncoderUtil.encode(this.method.getName());
        if (StringUtil.isEmpty((String)paramPath)) {
            return "?SAStruts.method=" + urlEncodedMethodName;
        }
        Matcher matcher = this.urlPatternRegexp.matcher(paramPath);
        if (!matcher.find()) {
            return "?SAStruts.method=" + urlEncodedMethodName;
        }
        if (this.urlParamNames.size() == 0) {
            return "?SAStruts.method=" + urlEncodedMethodName;
        }
        StringBuilder sb = new StringBuilder(50);
        sb.append("?");
        int index = 1;
        for (String name : this.urlParamNames) {
            if (index != 1) {
                sb.append("&");
            }
            sb.append(URLEncoderUtil.encode(name)).append("=").append(URLEncoderUtil.encode(matcher.group(index++)));
        }
        sb.append("&").append(METHOD_NAME).append("=").append(urlEncodedMethodName);
        return sb.toString();
    }
}

