/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.action;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.InvalidCancelException;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.IllegalPropertyRuntimeException;
import org.seasar.framework.beans.ParameterizedClassDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ModifierUtil;
import org.seasar.struts.action.ActionWrapper;
import org.seasar.struts.action.WrapperUtil;
import org.seasar.struts.config.S2ActionMapping;
import org.seasar.struts.config.S2ExecuteConfig;
import org.seasar.struts.exception.IndexedPropertyNotListArrayRuntimeException;
import org.seasar.struts.exception.NoParameterizedListRuntimeException;
import org.seasar.struts.exception.NoRoleRuntimeException;
import org.seasar.struts.util.ActionFormUtil;
import org.seasar.struts.util.ActionMessagesUtil;
import org.seasar.struts.util.S2ActionMappingUtil;
import org.seasar.struts.util.S2ExecuteConfigUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2RequestProcessor
extends RequestProcessor {
    private static final char NESTED_DELIM = '.';
    private static final char INDEXED_DELIM = '[';
    private static final char INDEXED_DELIM2 = ']';

    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String path = this.processPath(request = this.processMultipart(request), response);
        if (path == null) {
            return;
        }
        this.processLocale(request, response);
        this.processContent(request, response);
        this.processNoCache(request, response);
        if (!this.processPreprocess(request, response)) {
            return;
        }
        this.processCachedMessages(request, response);
        ActionMapping mapping = this.processMapping(request, response, path);
        if (mapping == null) {
            return;
        }
        ActionForm form = this.processActionForm(request, response, mapping);
        this.processPopulate(request, response, form, mapping);
        if (!this.processRoles(request, response, mapping)) {
            return;
        }
        try {
            if (!this.processValidate(request, response, form, mapping)) {
                return;
            }
        }
        catch (InvalidCancelException e) {
            ActionForward forward = this.processException(request, response, (Exception)((Object)e), form, mapping);
            this.processForwardConfig(request, response, (ForwardConfig)forward);
            return;
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        if (!this.processForward(request, response, mapping)) {
            return;
        }
        if (!this.processInclude(request, response, mapping)) {
            return;
        }
        Action action = this.processActionCreate(request, response, mapping);
        if (action == null) {
            return;
        }
        ActionForward forward = this.processActionPerform(request, response, action, form, mapping);
        this.processForwardConfig(request, response, (ForwardConfig)forward);
    }

    protected HttpServletRequest processMultipart(HttpServletRequest request) {
        HttpServletRequest result = super.processMultipart(request);
        SingletonS2ContainerFactory.getContainer().getExternalContext().setRequest((Object)result);
        return result;
    }

    protected ActionMapping processMapping(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        S2ActionMapping mapping = (S2ActionMapping)this.moduleConfig.findActionConfig(path);
        if (mapping != null) {
            request.setAttribute("org.apache.struts.action.mapping.instance", (Object)mapping);
            return mapping;
        }
        response.sendError(404, path + " not found.");
        return null;
    }

    protected void processExecuteConfig(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) {
        S2ExecuteConfig executeConfig = ((S2ActionMapping)mapping).findExecuteConfig(request);
        S2ExecuteConfigUtil.setExecuteConfig(executeConfig);
    }

    protected boolean processRoles(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        S2ExecuteConfig executeConfig = S2ExecuteConfigUtil.getExecuteConfig();
        if (executeConfig == null) {
            return true;
        }
        String[] roles = executeConfig.getRoles();
        if (roles == null || roles.length == 0) {
            return true;
        }
        for (int i = 0; i < roles.length; ++i) {
            if (!request.isUserInRole(roles[i])) continue;
            return true;
        }
        ActionForward forward = this.processException(request, response, (Exception)((Object)new NoRoleRuntimeException(request.getRemoteUser())), null, mapping);
        if (forward != null) {
            this.processForwardConfig(request, response, (ForwardConfig)forward);
        }
        return false;
    }

    protected ActionForm processActionForm(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) {
        String name = mapping.getName();
        if (name == null) {
            return null;
        }
        FormBeanConfig formConfig = this.moduleConfig.findFormBeanConfig(name);
        if (formConfig == null) {
            return null;
        }
        ActionForm actionForm = ActionFormUtil.getActionForm(request, mapping);
        if (actionForm != null) {
            return actionForm;
        }
        try {
            actionForm = formConfig.createActionForm(this.servlet);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        if ("request".equals(mapping.getScope())) {
            request.setAttribute(mapping.getAttribute(), (Object)actionForm);
        } else {
            HttpSession session = request.getSession();
            session.setAttribute(mapping.getAttribute(), (Object)actionForm);
        }
        return actionForm;
    }

    protected Action processActionCreate(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException {
        ActionWrapper action = null;
        try {
            action = new ActionWrapper((S2ActionMapping)mapping);
        }
        catch (Exception e) {
            log.error((Object)this.getInternal().getMessage("actionCreate", (Object)mapping.getPath()), (Throwable)e);
            response.sendError(500, this.getInternal().getMessage("actionCreate", (Object)mapping.getPath()));
            return null;
        }
        action.setServlet(this.servlet);
        return action;
    }

    protected void processPopulate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws ServletException {
        if (form == null) {
            return;
        }
        form.setServlet(this.servlet);
        String contentType = request.getContentType();
        String method = request.getMethod();
        form.setMultipartRequestHandler(null);
        MultipartRequestHandler multipartHandler = null;
        if (contentType != null && contentType.startsWith("multipart/form-data") && method.equalsIgnoreCase("POST") && (multipartHandler = this.getMultipartHandler(mapping.getMultipartClass())) != null) {
            multipartHandler.setServlet(this.servlet);
            multipartHandler.setMapping(mapping);
            multipartHandler.handleRequest(request);
            Boolean maxLengthExceeded = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded");
            if (maxLengthExceeded != null && maxLengthExceeded.booleanValue()) {
                form.setMultipartRequestHandler(multipartHandler);
                this.processExecuteConfig(request, response, mapping);
                return;
            }
        }
        this.processExecuteConfig(request, response, mapping);
        form.reset(mapping, request);
        Map<String, Object> params = this.getAllParameters(request, multipartHandler);
        S2ActionMapping actionMapping = (S2ActionMapping)mapping;
        for (String name : params.keySet()) {
            try {
                this.setProperty(actionMapping.getActionForm(), name, params.get(name));
            }
            catch (Throwable t) {
                throw new IllegalPropertyRuntimeException(actionMapping.getActionFormBeanDesc().getBeanClass(), name, t);
            }
        }
    }

    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.isExporablePath(uri)) {
            this.exportPropertiesToRequest(request, S2ActionMappingUtil.getActionMapping(), S2ExecuteConfigUtil.getExecuteConfig());
        }
        super.doForward(uri, request, response);
    }

    protected void exportPropertiesToRequest(HttpServletRequest request, S2ActionMapping actionMapping, S2ExecuteConfig executeConfig) {
        Object value;
        PropertyDesc pd;
        if (ActionMessagesUtil.hasErrors(request) || !executeConfig.isRemoveActionForm()) {
            Object actionForm = actionMapping.getActionForm();
            BeanDesc actionFormBeanDesc = actionMapping.getActionFormBeanDesc();
            for (int i = 0; i < actionFormBeanDesc.getPropertyDescSize(); ++i) {
                pd = actionFormBeanDesc.getPropertyDesc(i);
                if (!pd.isReadable() || !this.isExportableProperty(pd) || (value = WrapperUtil.convert(pd.getValue(actionForm))) == null) continue;
                request.setAttribute(pd.getPropertyName(), value);
            }
        }
        BeanDesc actionBeanDesc = actionMapping.getActionBeanDesc();
        for (int i = 0; i < actionBeanDesc.getPropertyDescSize(); ++i) {
            Object action = actionMapping.getAction();
            pd = actionBeanDesc.getPropertyDesc(i);
            if (!pd.isReadable() || !this.isExportableProperty(pd) || (value = WrapperUtil.convert(pd.getValue(action))) == null) continue;
            request.setAttribute(pd.getPropertyName(), value);
        }
    }

    protected boolean isExportableProperty(PropertyDesc propertyDesc) {
        return !propertyDesc.getPropertyType().getName().startsWith("javax.servlet") && !propertyDesc.getPropertyName().equals("requestScope") && !propertyDesc.getPropertyName().equals("sessionScope") && !propertyDesc.getPropertyName().equals("appplicationScope");
    }

    protected boolean isExporablePath(String path) {
        return path != null && path.indexOf(".") > 0 && path.indexOf(".do") < 0;
    }

    protected void setProperty(Object bean, String name, Object value) {
        if (bean == null) {
            return;
        }
        int nestedIndex = name.indexOf(46);
        int indexedIndex = name.indexOf(91);
        if (nestedIndex < 0 && indexedIndex < 0) {
            this.setSimpleProperty(bean, name, value);
        } else if (nestedIndex >= 0 && indexedIndex >= 0) {
            if (nestedIndex < indexedIndex) {
                this.setProperty(this.getSimpleProperty(bean, name.substring(0, nestedIndex)), name.substring(nestedIndex + 1), value);
            } else {
                IndexParsedResult result = this.parseIndex(name.substring(indexedIndex + 1));
                bean = this.getIndexedProperty(bean, name.substring(0, indexedIndex), result.indexes);
                this.setProperty(bean, result.name, value);
            }
        } else if (nestedIndex >= 0) {
            this.setProperty(this.getSimpleProperty(bean, name.substring(0, nestedIndex)), name.substring(nestedIndex + 1), value);
        } else {
            IndexParsedResult result = this.parseIndex(name.substring(indexedIndex + 1));
            this.setIndexedProperty(bean, name.substring(0, indexedIndex), result.indexes, value);
        }
    }

    protected void setSimpleProperty(Object bean, String name, Object value) {
        if (bean instanceof Map) {
            Map m = (Map)bean;
            if (value instanceof String[]) {
                String[] values = (String[])value;
                m.put(name, values.length > 0 ? values[0] : null);
            } else {
                m.put(name, value);
            }
            return;
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(bean.getClass());
        if (!beanDesc.hasPropertyDesc(name)) {
            return;
        }
        PropertyDesc pd = beanDesc.getPropertyDesc(name);
        if (!pd.isWritable()) {
            return;
        }
        if (pd.getPropertyType().isArray()) {
            pd.setValue(bean, value);
        } else if (List.class.isAssignableFrom(pd.getPropertyType())) {
            List<String> list = ModifierUtil.isAbstract((Class)pd.getPropertyType()) ? new ArrayList() : (List)ClassUtil.newInstance((Class)pd.getPropertyType());
            list.addAll(Arrays.asList((String[])value));
            pd.setValue(bean, list);
        } else if (value == null) {
            pd.setValue(bean, null);
        } else if (value instanceof String[]) {
            String[] values = (String[])value;
            pd.setValue(bean, values.length > 0 ? values[0] : null);
        } else {
            pd.setValue(bean, value);
        }
    }

    protected Object getSimpleProperty(Object bean, String name) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(bean.getClass());
        if (!beanDesc.hasPropertyDesc(name)) {
            return null;
        }
        PropertyDesc pd = beanDesc.getPropertyDesc(name);
        if (!pd.isReadable()) {
            return null;
        }
        HashMap value = pd.getValue(bean);
        if (value == null) {
            if (!ModifierUtil.isAbstract((Class)pd.getPropertyType())) {
                value = ClassUtil.newInstance((Class)pd.getPropertyType());
                if (pd.isWritable()) {
                    pd.setValue(bean, value);
                }
            } else if (Map.class.isAssignableFrom(pd.getPropertyType())) {
                value = new HashMap();
                if (pd.isWritable()) {
                    pd.setValue(bean, value);
                }
            }
        }
        return value;
    }

    protected Object getIndexedProperty(Object bean, String name, int[] indexes) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(bean.getClass());
        if (!beanDesc.hasPropertyDesc(name)) {
            return null;
        }
        PropertyDesc pd = beanDesc.getPropertyDesc(name);
        if (!pd.isReadable()) {
            return null;
        }
        if (pd.getPropertyType().isArray()) {
            Object array = pd.getValue(bean);
            Class<?> elementType = this.getArrayElementType(pd.getPropertyType(), indexes.length);
            if (array == null) {
                int[] newIndexes = new int[indexes.length];
                newIndexes[0] = indexes[0] + 1;
                array = Array.newInstance(elementType, newIndexes);
            }
            array = this.expand(array, indexes, elementType);
            pd.setValue(bean, array);
            return this.getArrayValue(array, indexes, elementType);
        }
        if (List.class.isAssignableFrom(pd.getPropertyType())) {
            List<Object> list = (ArrayList<Object>)pd.getValue(bean);
            if (list == null) {
                list = new ArrayList<Object>(Math.max(50, indexes[0]));
                pd.setValue(bean, list);
            }
            ParameterizedClassDesc pcd = pd.getParameterizedClassDesc();
            for (int i = 0; i < indexes.length; ++i) {
                int j;
                if (pcd == null || !pcd.isParameterizedClass() || !List.class.isAssignableFrom(pcd.getRawClass())) {
                    StringBuilder sb = new StringBuilder();
                    for (j = 0; j <= i; ++j) {
                        sb.append("[").append(indexes[j]).append("]");
                    }
                    throw new NoParameterizedListRuntimeException(this.getRealClass(beanDesc.getBeanClass()), pd.getPropertyName() + sb);
                }
                int size = list.size();
                pcd = pcd.getArguments()[0];
                for (j = size; j <= indexes[i]; ++j) {
                    if (i == indexes.length - 1) {
                        list.add(ClassUtil.newInstance(this.convertClass(pcd.getRawClass())));
                        continue;
                    }
                    list.add(new ArrayList());
                }
                if (i >= indexes.length - 1) continue;
                list = (List)list.get(indexes[i]);
            }
            return list.get(indexes[indexes.length - 1]);
        }
        throw new IndexedPropertyNotListArrayRuntimeException(this.getRealClass(beanDesc.getBeanClass()), pd.getPropertyName());
    }

    protected void setIndexedProperty(Object bean, String name, int[] indexes, Object value) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(bean.getClass());
        if (!beanDesc.hasPropertyDesc(name)) {
            return;
        }
        PropertyDesc pd = beanDesc.getPropertyDesc(name);
        if (!pd.isWritable()) {
            return;
        }
        if (value.getClass().isArray() && Array.getLength(value) > 0) {
            value = Array.get(value, 0);
        }
        if (pd.getPropertyType().isArray()) {
            Object array = pd.getValue(bean);
            Class<?> elementType = this.getArrayElementType(pd.getPropertyType(), indexes.length);
            if (array == null) {
                int[] newIndexes = new int[indexes.length];
                newIndexes[0] = indexes[0] + 1;
                array = Array.newInstance(elementType, newIndexes);
            }
            array = this.expand(array, indexes, elementType);
            pd.setValue(bean, array);
            this.setArrayValue(array, indexes, value);
        } else if (List.class.isAssignableFrom(pd.getPropertyType())) {
            List<Object> list = (ArrayList<Object>)pd.getValue(bean);
            if (list == null) {
                list = new ArrayList<Object>(Math.max(50, indexes[0]));
                pd.setValue(bean, list);
            }
            ParameterizedClassDesc pcd = pd.getParameterizedClassDesc();
            for (int i = 0; i < indexes.length; ++i) {
                int j;
                if (pcd == null || !pcd.isParameterizedClass() || !List.class.isAssignableFrom(pcd.getRawClass())) {
                    StringBuilder sb = new StringBuilder();
                    for (j = 0; j <= i; ++j) {
                        sb.append("[").append(indexes[j]).append("]");
                    }
                    throw new NoParameterizedListRuntimeException(this.getRealClass(beanDesc.getBeanClass()), pd.getPropertyName() + sb);
                }
                int size = list.size();
                pcd = pcd.getArguments()[0];
                for (j = size; j <= indexes[i]; ++j) {
                    if (i == indexes.length - 1) {
                        list.add(ClassUtil.newInstance(this.convertClass(pcd.getRawClass())));
                        continue;
                    }
                    list.add(new ArrayList());
                }
                if (i >= indexes.length - 1) continue;
                list = (List)list.get(indexes[i]);
            }
            list.set(indexes[indexes.length - 1], value);
        } else {
            throw new IndexedPropertyNotListArrayRuntimeException(this.getRealClass(beanDesc.getBeanClass()), pd.getPropertyName());
        }
    }

    protected Class<?> getArrayElementType(Class<?> clazz, int depth) {
        for (int i = 0; i < depth; ++i) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    protected Object expand(Object array, int[] indexes, Class<?> elementType) {
        int[] newIndexes;
        int length = Array.getLength(array);
        if (length <= indexes[0]) {
            newIndexes = new int[indexes.length];
            newIndexes[0] = indexes[0] + 1;
            Object newArray = Array.newInstance(elementType, newIndexes);
            System.arraycopy(array, 0, newArray, 0, length);
            array = newArray;
        }
        if (indexes.length > 1) {
            newIndexes = new int[indexes.length - 1];
            for (int i = 1; i < indexes.length; ++i) {
                newIndexes[i - 1] = indexes[i];
            }
            Array.set(array, indexes[0], this.expand(Array.get(array, indexes[0]), newIndexes, elementType));
        }
        return array;
    }

    protected Object getArrayValue(Object array, int[] indexes, Class<?> elementType) {
        Object value = array;
        elementType = this.convertClass(elementType);
        for (int i = 0; i < indexes.length; ++i) {
            Object value2 = Array.get(value, indexes[i]);
            if (i == indexes.length - 1 && value2 == null) {
                value2 = ClassUtil.newInstance(elementType);
                Array.set(value, indexes[i], value2);
            }
            value = value2;
        }
        return value;
    }

    protected void setArrayValue(Object array, int[] indexes, Object value) {
        for (int i = 0; i < indexes.length - 1; ++i) {
            array = Array.get(array, indexes[i]);
        }
        Array.set(array, indexes[indexes.length - 1], value);
    }

    protected Class<?> convertClass(Class<?> clazz) {
        if (ModifierUtil.isAbstract(clazz) && Map.class.isAssignableFrom(clazz)) {
            return HashMap.class;
        }
        return clazz;
    }

    protected IndexParsedResult parseIndex(String name) {
        IndexParsedResult result;
        block4: {
            result = new IndexParsedResult();
            while (true) {
                int index;
                if ((index = name.indexOf(93)) < 0) {
                    throw new IllegalArgumentException("] is not found in " + name);
                }
                result.indexes = ArrayUtil.add((int[])result.indexes, (int)Integer.valueOf(name.substring(0, index)));
                if ((name = name.substring(index + 1)).length() == 0) break block4;
                if (name.charAt(0) != '[') break;
                name = name.substring(1);
            }
            if (name.charAt(0) == '.') {
                name = name.substring(1);
            } else {
                throw new IllegalArgumentException(name);
            }
        }
        result.name = name;
        return result;
    }

    protected Class<?> getRealClass(Class<?> clazz) {
        if (clazz.getName().indexOf("$$EnhancedByS2AOP$$") > 0) {
            return clazz.getSuperclass();
        }
        return clazz;
    }

    protected MultipartRequestHandler getMultipartHandler(String multipartClass) throws ServletException {
        MultipartRequestHandler multipartHandler = null;
        if (multipartClass != null) {
            try {
                multipartHandler = (MultipartRequestHandler)ClassUtil.newInstance((String)multipartClass);
            }
            catch (Throwable t) {
                log.error((Object)t.getMessage(), t);
                throw new ServletException(t.getMessage(), t);
            }
            if (multipartHandler != null) {
                return multipartHandler;
            }
        }
        if ((multipartClass = this.moduleConfig.getControllerConfig().getMultipartClass()) != null) {
            try {
                multipartHandler = (MultipartRequestHandler)ClassUtil.newInstance((String)multipartClass);
            }
            catch (Throwable t) {
                log.error((Object)t.getMessage(), t);
                throw new ServletException(t.getMessage(), t);
            }
            if (multipartHandler != null) {
                return multipartHandler;
            }
        }
        return null;
    }

    protected Map<String, Object> getAllParameters(HttpServletRequest request, MultipartRequestHandler multipartHandler) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
        }
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            params.put(name, request.getParameterValues(name));
        }
        if (multipartHandler != null) {
            Hashtable elements = multipartHandler.getAllElements();
            params.putAll(elements);
        }
        return params;
    }

    protected static class IndexParsedResult {
        public int[] indexes = new int[0];
        public String name;

        protected IndexParsedResult() {
        }
    }
}

