/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.config.S2ExecuteConfig;
import org.seasar.struts.util.RequestUtil;
import org.seasar.struts.util.RoutingUtil;
import org.seasar.struts.util.S2ExecuteConfigUtil;

public class RoutingFilter
implements Filter {
    protected boolean jspDirectAccess = false;

    public void init(FilterConfig config) throws ServletException {
        String access = config.getInitParameter("jspDirectAccess");
        if (!StringUtil.isBlank((String)access)) {
            this.jspDirectAccess = Boolean.valueOf(access);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String path;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String contextPath = req.getContextPath();
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        if (!this.processDirectAccess(request, response, chain, path = RequestUtil.getPath(req))) {
            return;
        }
        if (path.indexOf(46) < 0) {
            String[] names = StringUtil.split((String)path, (String)"/");
            S2Container container = SingletonS2ContainerFactory.getContainer();
            StringBuilder sb = new StringBuilder(50);
            for (int i = 0; i < names.length; ++i) {
                S2ExecuteConfig executeConfig;
                String queryString;
                String paramPath;
                String actionPath;
                if (container.hasComponentDef((Object)(sb + names[i] + "Action"))) {
                    actionPath = RoutingUtil.getActionPath(names, i);
                    paramPath = RoutingUtil.getParamPath(names, i + 1);
                    if (StringUtil.isEmpty((String)paramPath)) {
                        if (!path.endsWith("/")) {
                            queryString = "";
                            if (req.getQueryString() != null) {
                                queryString = "?" + req.getQueryString();
                            }
                            res.sendRedirect(contextPath + path + "/" + queryString);
                            return;
                        }
                        if (S2ExecuteConfigUtil.findExecuteConfig(actionPath, req) != null) {
                            this.forward((HttpServletRequest)request, (HttpServletResponse)response, actionPath, null, null);
                            return;
                        }
                    } else {
                        executeConfig = S2ExecuteConfigUtil.findExecuteConfig(actionPath, paramPath);
                        if (executeConfig != null) {
                            this.forward((HttpServletRequest)request, (HttpServletResponse)response, actionPath, paramPath, executeConfig);
                            return;
                        }
                    }
                }
                if (container.hasComponentDef((Object)(sb + "indexAction"))) {
                    actionPath = RoutingUtil.getActionPath(names, i - 1) + "/index";
                    paramPath = RoutingUtil.getParamPath(names, i);
                    if (StringUtil.isEmpty((String)paramPath)) {
                        if (!path.endsWith("/")) {
                            queryString = "";
                            if (req.getQueryString() != null) {
                                queryString = "?" + req.getQueryString();
                            }
                            res.sendRedirect(contextPath + path + "/" + queryString);
                            return;
                        }
                        if (S2ExecuteConfigUtil.findExecuteConfig(actionPath, req) != null) {
                            this.forward((HttpServletRequest)request, (HttpServletResponse)response, actionPath, null, null);
                            return;
                        }
                    } else {
                        executeConfig = S2ExecuteConfigUtil.findExecuteConfig(actionPath, paramPath);
                        if (executeConfig != null) {
                            this.forward((HttpServletRequest)request, (HttpServletResponse)response, actionPath, paramPath, executeConfig);
                            return;
                        }
                    }
                }
                sb.append(names[i] + "_");
            }
            if (container.hasComponentDef((Object)(sb + "indexAction"))) {
                String actionPath = RoutingUtil.getActionPath(names, names.length - 1) + "/index";
                if (!path.endsWith("/")) {
                    String queryString = "";
                    if (req.getQueryString() != null) {
                        queryString = "?" + req.getQueryString();
                    }
                    res.sendRedirect(contextPath + path + "/" + queryString);
                    return;
                }
                if (S2ExecuteConfigUtil.findExecuteConfig(actionPath, req) != null) {
                    this.forward((HttpServletRequest)request, (HttpServletResponse)response, actionPath, null, null);
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    protected boolean processDirectAccess(ServletRequest request, ServletResponse response, FilterChain chain, String path) throws IOException {
        if (!this.jspDirectAccess && ((HttpServletRequest)request).getMethod().equalsIgnoreCase("get") && path.endsWith(".jsp")) {
            String message = "Direct access for JSP is not permitted.";
            if (path.endsWith("index.jsp")) {
                message = message + " Remove \"index.jsp\" from welcome-file-list of (default) \"web.xml\".";
            }
            ((HttpServletResponse)response).sendError(400, message);
            return false;
        }
        return true;
    }

    protected void forward(HttpServletRequest request, HttpServletResponse response, String actionPath, String paramPath, S2ExecuteConfig executeConfig) throws IOException, ServletException {
        String forwardPath = actionPath + ".do";
        if (executeConfig != null) {
            forwardPath = forwardPath + executeConfig.getQueryString(paramPath);
        }
        request.getRequestDispatcher(forwardPath).forward((ServletRequest)request, (ServletResponse)response);
    }
}

