/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.action;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.struts.action.WrapperUtil;

public class BeanWrapper
implements Map {
    private static final char INDEXED_DELIM = '[';
    private static final char INDEXED_DELIM2 = ']';
    protected Object bean;
    protected BeanDesc beanDesc;

    public BeanWrapper(Object bean) {
        this.bean = bean;
        this.beanDesc = BeanDescFactory.getBeanDesc(bean.getClass());
    }

    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException("The key parameter must not be null.");
        }
        String k = key.toString();
        int pos = k.lastIndexOf(91);
        if (pos > 0) {
            Class type;
            Object value;
            int endPos = k.lastIndexOf(93);
            if (pos >= endPos) {
                throw new IllegalArgumentException("The key(" + k + ") is invalid.");
            }
            int index = Integer.valueOf(k.substring(pos + 1, endPos));
            String name = k.substring(0, pos);
            if (name.indexOf(91) > 0) {
                value = this.get(name);
                type = value.getClass();
            } else {
                PropertyDesc pd = this.beanDesc.getPropertyDesc(name);
                if (!pd.isReadable()) {
                    return null;
                }
                value = pd.getValue(this.bean);
                if (value == null) {
                    return null;
                }
                type = pd.getPropertyType();
            }
            if (type.isArray()) {
                return WrapperUtil.convert(Array.get(value, index));
            }
            if (List.class.isAssignableFrom(type)) {
                return WrapperUtil.convert(((List)value).get(index));
            }
            throw new IllegalStateException("Index property must be an array or a list.");
        }
        PropertyDesc pd = this.beanDesc.getPropertyDesc(k);
        if (!pd.isReadable()) {
            return null;
        }
        return WrapperUtil.convert(pd.getValue(this.bean));
    }

    public Object put(Object key, Object value) {
        PropertyDesc pd = this.beanDesc.getPropertyDesc(key.toString());
        pd.setValue(this.bean, value);
        return null;
    }

    public void clear() {
        throw new UnsupportedOperationException("clear");
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        return this.beanDesc.hasPropertyDesc(key.toString());
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("containsValue");
    }

    public Set entrySet() {
        HashSet<BeanEntry> set = new HashSet<BeanEntry>();
        int size = this.beanDesc.getPropertyDescSize();
        for (int i = 0; i < size; ++i) {
            PropertyDesc pd = this.beanDesc.getPropertyDesc(i);
            set.add(new BeanEntry(this.bean, pd));
        }
        return set;
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException("isEmpty");
    }

    public Set keySet() {
        HashSet<String> set = new HashSet<String>();
        int size = this.beanDesc.getPropertyDescSize();
        for (int i = 0; i < size; ++i) {
            PropertyDesc pd = this.beanDesc.getPropertyDesc(i);
            set.add(pd.getPropertyName());
        }
        return set;
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException("putAll");
    }

    public Object remove(Object key) {
        return this.put(key, (Object)null);
    }

    public int size() {
        return this.beanDesc.getPropertyDescSize();
    }

    public Collection values() {
        throw new UnsupportedOperationException("values");
    }

    public String toString() {
        return this.bean.toString();
    }

    protected static class BeanEntry
    implements Map.Entry {
        protected PropertyDesc propDesc;
        protected Object bean;

        public BeanEntry(Object bean, PropertyDesc propDesc) {
            this.propDesc = propDesc;
            this.bean = bean;
        }

        public Object getKey() {
            return this.propDesc.getPropertyName();
        }

        public Object getValue() {
            if (!this.propDesc.isReadable()) {
                return null;
            }
            return WrapperUtil.convert(this.propDesc.getValue(this.bean));
        }

        public Object setValue(Object value) {
            this.propDesc.setValue(this.bean, value);
            return null;
        }
    }
}

