/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.rpc.remoting.service.impl;

import org.seasar.flex2.rpc.remoting.service.RemotingServiceLocator;
import org.seasar.flex2.rpc.remoting.service.RemotingServiceRepository;
import org.seasar.flex2.rpc.remoting.service.annotation.factory.AnnotationHandlerFactory;
import org.seasar.flex2.rpc.remoting.service.annotation.handler.AnnotationHandler;
import org.seasar.flex2.rpc.remoting.service.exception.InvalidServiceRuntimeException;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.util.ClassUtil;

public class RemotingServiceLocatorImpl
implements RemotingServiceLocator {
    private static final AnnotationHandler annotationHandler = AnnotationHandlerFactory.getAnnotationHandler();
    protected S2Container container;
    protected RemotingServiceRepository repository;

    protected static final boolean canRegisterService(ComponentDef componentDef) {
        boolean canRegisterService = true;
        if (!RemotingServiceLocatorImpl.hasRemotingServiceMetadata(componentDef) && !RemotingServiceLocatorImpl.hasRemotingServiceAnnotation(componentDef)) {
            canRegisterService = false;
        }
        return canRegisterService;
    }

    private static final boolean hasRemotingServiceAnnotation(ComponentDef componentDef) {
        return annotationHandler.hasRemotingService(componentDef);
    }

    private static final boolean hasRemotingServiceMetadata(ComponentDef componentDef) {
        return componentDef.getMetaDef("RemotingService") != null;
    }

    public S2Container getContainer() {
        return this.container;
    }

    public RemotingServiceRepository getRepository() {
        return this.repository;
    }

    public Object getService(String serviceName) {
        ComponentDef serviceComponentDef;
        if (HotdeployUtil.isHotdeploy()) {
            this.repository.removeService(serviceName);
        }
        if (this.repository.hasService(serviceName)) {
            serviceComponentDef = this.repository.getService(serviceName);
        } else {
            serviceComponentDef = this.getServiceComponentDef(serviceName);
            if (RemotingServiceLocatorImpl.canRegisterService(serviceComponentDef)) {
                this.repository.addService(serviceName, serviceComponentDef);
            } else {
                throw new InvalidServiceRuntimeException(serviceName);
            }
        }
        return serviceComponentDef.getComponent();
    }

    public boolean isSupportService(ComponentDef componentDef) {
        boolean isSupport = this.repository.hasService(componentDef.getComponentName());
        if (!isSupport) {
            isSupport = RemotingServiceLocatorImpl.canRegisterService(componentDef);
        }
        return isSupport;
    }

    public boolean isSupportService(String serviceName) {
        boolean isSupport = this.repository.hasService(serviceName);
        if (!isSupport && this.hasServiceComponentByName(serviceName)) {
            isSupport = RemotingServiceLocatorImpl.canRegisterService(this.getServiceComponentDef(serviceName));
        }
        return isSupport;
    }

    public void setContainer(S2Container container) {
        this.container = container.getRoot();
    }

    public void setRepository(RemotingServiceRepository repository) {
        this.repository = repository;
    }

    protected final ComponentDef getServiceComponentDef(String serviceName) {
        ComponentDef componentDef;
        S2Container root = this.container;
        if (root.hasComponentDef((Object)serviceName)) {
            componentDef = root.getComponentDef((Object)serviceName);
        } else {
            Class clazz = ClassUtil.forName((String)serviceName);
            componentDef = root.getComponentDef((Object)clazz);
        }
        return componentDef;
    }

    private final boolean hasServiceComponentByName(String serviceName) {
        S2Container root = this.container;
        boolean isSupport = root.hasComponentDef((Object)serviceName);
        if (!isSupport) {
            try {
                Class clazz = ClassUtil.forName((String)serviceName);
                isSupport = root.hasComponentDef((Object)clazz);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return isSupport;
    }
}

