/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.rpc.remoting.message.io.reader.impl;

import java.io.DataInputStream;
import java.io.IOException;
import org.seasar.flex2.core.format.amf.io.reader.factory.AmfDataReaderFactory;
import org.seasar.flex2.core.format.amf0.type.Amf0SharedObject;
import org.seasar.flex2.rpc.remoting.message.data.Message;
import org.seasar.flex2.rpc.remoting.message.data.MessageBody;
import org.seasar.flex2.rpc.remoting.message.data.factory.MessageBodyFactory;
import org.seasar.flex2.rpc.remoting.message.data.factory.MessageFactory;
import org.seasar.flex2.rpc.remoting.message.data.factory.MessageHeaderFactory;
import org.seasar.flex2.rpc.remoting.message.io.reader.MessageReader;

public class AmfMessageReaderImpl
implements MessageReader {
    protected AmfDataReaderFactory amfDataReaderFactory;
    protected DataInputStream inputStream;
    protected Message message;
    protected MessageBodyFactory messageBodyFactory;
    protected MessageFactory messageFactory;
    protected MessageHeaderFactory messageHeaderFactory;
    private Amf0SharedObject sharedObject;

    public void config(DataInputStream inputStream) {
        this.inputStream = inputStream;
        this.message = this.createMessage();
    }

    public AmfDataReaderFactory getAmfDataReaderFactory() {
        return this.amfDataReaderFactory;
    }

    public MessageBodyFactory getMessageBodyFactory() {
        return this.messageBodyFactory;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public MessageHeaderFactory getMessageHeaderFactory() {
        return this.messageHeaderFactory;
    }

    public Message read() throws IOException {
        this.readVersion();
        this.readHeader();
        this.readBodies();
        return this.message;
    }

    public void setDataReaderFactory(AmfDataReaderFactory amfDataReaderFactory) {
        this.amfDataReaderFactory = amfDataReaderFactory;
    }

    public void setMessageBodyFactory(MessageBodyFactory bodyFactory) {
        this.messageBodyFactory = bodyFactory;
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public void setMessageHeaderFactory(MessageHeaderFactory messageHeaderFactory) {
        this.messageHeaderFactory = messageHeaderFactory;
    }

    public void setSharedObject(Amf0SharedObject sharedObject) {
        this.sharedObject = sharedObject;
    }

    protected void clean() {
        this.sharedObject.initialize();
    }

    protected MessageBody createBody(String target, String response, Object data) {
        return this.messageBodyFactory.createBody(target, response, data);
    }

    protected Message createMessage() {
        return this.messageFactory.createRequestMessage();
    }

    protected void readBodies() throws IOException {
        int bodySize = this.inputStream.readUnsignedShort();
        for (int i = 0; i < bodySize; ++i) {
            this.clean();
            String target = this.inputStream.readUTF();
            String response = this.inputStream.readUTF();
            this.inputStream.readInt();
            this.message.addBody(this.createBody(target, response, this.readData()));
        }
    }

    protected final Object readData() throws IOException {
        byte dataType = this.inputStream.readByte();
        return this.amfDataReaderFactory.createDataReader(dataType).read(this.inputStream);
    }

    protected void readHeader() throws IOException {
        int headerCount = this.inputStream.readUnsignedShort();
        for (int i = 0; i < headerCount; ++i) {
            String name = this.inputStream.readUTF();
            boolean isRequired = this.inputStream.readBoolean();
            this.inputStream.readInt();
            this.message.addHeader(this.messageHeaderFactory.createHeader(name, this.readData(), isRequired));
        }
    }

    protected final void readVersion() throws IOException {
        this.message.setVersion(this.inputStream.readUnsignedShort());
    }
}

