/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.core.format.amf3.io.reader.impl;

import java.io.DataInputStream;
import java.io.IOException;
import org.seasar.flex2.core.format.amf3.io.reader.Amf3DataReader;
import org.seasar.flex2.core.format.amf3.io.reader.impl.AbstractAmf3ObjectReaderImpl;

public class Amf3ByteArrayReaderImpl
extends AbstractAmf3ObjectReaderImpl
implements Amf3DataReader {
    private static final int READ_BUFFER_SIZE = 4096;

    public Object read(DataInputStream inputStream) throws IOException {
        return this.readObject(inputStream);
    }

    protected final Object readInlinedObject(int reference, DataInputStream inputStream) throws IOException {
        byte[] byteArray = this.readByteArrayData(reference, inputStream);
        this.addObjectReference(byteArray);
        return byteArray;
    }

    protected final Object readReferencedObject(int reference, DataInputStream inputStream) throws IOException {
        return this.getObjectAt(reference >>> 1);
    }

    private final byte[] readByteArrayData(int bytearrayDef, DataInputStream inputStream) throws IOException {
        int bytearrayLength = bytearrayDef >> 1;
        byte[] bytearrayData = new byte[bytearrayLength];
        byte[] readBuffer = new byte[4096];
        int readByteLength = 0;
        for (int totalReadByteLength = 0; totalReadByteLength < bytearrayLength; totalReadByteLength += readByteLength) {
            readByteLength = bytearrayLength - totalReadByteLength > 4096 ? inputStream.read(readBuffer) : inputStream.read(readBuffer, 0, bytearrayLength - totalReadByteLength);
            System.arraycopy(readBuffer, 0, bytearrayData, totalReadByteLength, readByteLength);
        }
        return bytearrayData;
    }
}

