/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.zpt.mobylet.interceptor;

import java.util.ArrayList;
import net.skirnir.freyja.Attribute;
import net.skirnir.freyja.TagEvaluatorUtils;
import net.skirnir.freyja.TemplateContext;
import org.mobylet.core.image.ImageCodec;
import org.mobylet.core.util.ImageUtils;
import org.mobylet.core.util.StringUtils;
import org.mobylet.view.designer.ImageDesigner;
import org.mobylet.view.designer.SingletonDesigner;
import org.seasar.ymir.zpt.TagRenderingInterceptor;
import org.seasar.ymir.zpt.TagRenderingInterceptorChain;

public class ImgInterceptor
implements TagRenderingInterceptor {
    private static final String TAGNAME = "m:img";
    private static final String TAGNAME_IMG = "img";
    private static final String ATTRNAME_MAGNIWIDTH = "magniWidth";
    private static final String ATTRNAME_SCALETYPE = "scaleType";
    private static final String ATTRNAME_SRC = "src";
    private static final String ATTRNAME_CODEC = "codec";
    private static final String ATTRNAME_USEFILTER = "useFilter";
    private static final String[] SPECIAL_TAG_PATTERN_STRINGS = new String[]{"^m:img$"};

    public String[] getSpecialAttributePatternStrings() {
        return null;
    }

    public String[] getSpecialTagPatternStrings() {
        return SPECIAL_TAG_PATTERN_STRINGS;
    }

    public String render(TemplateContext context, String name, Attribute[] attributes, String body, TagRenderingInterceptorChain chain) {
        if (name.equals(TAGNAME)) {
            String magniWidth = null;
            String scaleType = null;
            Attribute srcAttr = null;
            String codec = null;
            String useFilter = null;
            ArrayList<Attribute> attrs = new ArrayList<Attribute>();
            for (Attribute attr : attributes) {
                String attrName = attr.getName();
                if (ATTRNAME_MAGNIWIDTH.equals(attrName)) {
                    magniWidth = TagEvaluatorUtils.defilter((String)attr.getValue());
                    continue;
                }
                if (ATTRNAME_SCALETYPE.equals(attrName)) {
                    scaleType = TagEvaluatorUtils.defilter((String)attr.getValue());
                    continue;
                }
                if (ATTRNAME_SRC.equals(attrName)) {
                    srcAttr = attr;
                    continue;
                }
                if (ATTRNAME_CODEC.equals(attrName)) {
                    codec = TagEvaluatorUtils.defilter((String)attr.getValue());
                    continue;
                }
                if (ATTRNAME_USEFILTER.equals(attrName)) {
                    useFilter = TagEvaluatorUtils.defilter((String)attr.getValue());
                    continue;
                }
                attrs.add(attr);
            }
            if (srcAttr == null) {
                throw new IllegalArgumentException("tag 'm:img' must have attribute 'src'");
            }
            if (magniWidth == null) {
                throw new IllegalArgumentException("tag 'm:img' must have attribute 'magniWidth'");
            }
            ImageDesigner designer = (ImageDesigner)SingletonDesigner.getDesigner(ImageDesigner.class);
            String imgSrc = designer.getSrc(TagEvaluatorUtils.defilter((String)srcAttr.getValue()), (StringUtils.isEmpty(magniWidth) ? null : Double.valueOf(Double.parseDouble(magniWidth))).doubleValue(), ImageUtils.getScaleType((String)scaleType), StringUtils.isEmpty(codec) ? null : ImageCodec.valueOf(codec), "TRUE".equalsIgnoreCase(useFilter));
            attrs.add(new Attribute(ATTRNAME_SRC, TagEvaluatorUtils.filter((String)imgSrc), srcAttr.getQuote()));
            name = TAGNAME_IMG;
            attributes = attrs.toArray(new Attribute[0]);
        }
        return chain.render(context, name, attributes, body);
    }
}

