/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.zpt.mobylet.interceptor;

import net.skirnir.freyja.Attribute;
import net.skirnir.freyja.TemplateContext;
import org.mobylet.core.Carrier;
import org.mobylet.view.designer.EmojiDesigner;
import org.mobylet.view.designer.SingletonDesigner;
import org.seasar.ymir.zpt.TagRenderingInterceptor;
import org.seasar.ymir.zpt.TagRenderingInterceptorChain;

public class EmojiInterceptor
implements TagRenderingInterceptor {
    private static final String TAGNAME = "m:emoji";
    private static final String ATTRNAME_NAME = "name";
    private static final String ATTRNAME_CARRIER = "carrier";
    private static final String[] SPECIAL_TAG_PATTERN_STRINGS = new String[]{"^m:emoji$"};

    public String[] getSpecialAttributePatternStrings() {
        return null;
    }

    public String[] getSpecialTagPatternStrings() {
        return SPECIAL_TAG_PATTERN_STRINGS;
    }

    public String render(TemplateContext context, String name, Attribute[] attributes, String body, TagRenderingInterceptorChain chain) {
        if (name.equals(TAGNAME)) {
            String emojiName = null;
            Carrier carrier = Carrier.DOCOMO;
            for (Attribute attr : attributes) {
                String attrName = attr.getName();
                if (ATTRNAME_NAME.equals(attrName)) {
                    emojiName = attr.getValue();
                    continue;
                }
                if (!ATTRNAME_CARRIER.equals(attrName)) continue;
                carrier = Carrier.valueOf((String)attr.getValue());
            }
            if (emojiName == null || emojiName.length() == 0) {
                return "";
            }
            return ((EmojiDesigner)SingletonDesigner.getDesigner(EmojiDesigner.class)).get(emojiName, carrier);
        }
        return chain.render(context, name, attributes, body);
    }
}

