/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.exception.DfIllegalPropertyTypeException;
import org.seasar.dbflute.exception.DfRequiredPropertyNotFoundException;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.logic.jdbc.urlanalyzer.DfUrlAnalyzer;
import org.seasar.dbflute.logic.jdbc.urlanalyzer.factory.DfUrlAnalyzerFactory;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;
import org.seasar.dbflute.properties.assistant.DfAdditionalSchemaInfo;
import org.seasar.dbflute.properties.assistant.DfConnectionProperties;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.DfTypeUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfDatabaseProperties
extends DfAbstractHelperProperties {
    private static final Log _log = LogFactory.getLog(DfDatabaseProperties.class);
    public static final String NO_NAME_SCHEMA = "$$NoNameSchema$$";
    protected DatabaseInfo _databaseInfo = new DatabaseInfo();
    protected String _mainCatalog = null;
    protected boolean _catalogDone = false;
    protected UnifiedSchema _mainSchema = null;
    protected Properties _databaseConnectionProperties;
    protected Map<String, List<String>> _columnExceptMap;
    protected Map<String, DfAdditionalSchemaInfo> _additionalSchemaMap;

    public DfDatabaseProperties(Properties prop) {
        super(prop);
    }

    public String getDatabaseDriver() {
        return this._databaseInfo.getDatabaseDriver();
    }

    public String getDatabaseUrl() {
        return this._databaseInfo.getDatabaseUrl();
    }

    public String getDatabaseCatalog() {
        if (this._catalogDone) {
            return this._mainCatalog;
        }
        this._catalogDone = true;
        String catalog = this._databaseInfo.getDatabaseCatalog();
        if (Srl.is_Null_or_TrimmedEmpty((String)catalog)) {
            DfUrlAnalyzerFactory factory = new DfUrlAnalyzerFactory(this.getBasicProperties(), this.getDatabaseUrl());
            DfUrlAnalyzer analyzer = factory.createAnalyzer();
            String extracted = analyzer.extractCatalog();
            catalog = Srl.is_NotNull_and_NotTrimmedEmpty((String)extracted) ? extracted : null;
        }
        this._mainCatalog = this.filterDatabaseCatalog(catalog);
        return this._mainCatalog;
    }

    protected String filterDatabaseCatalog(String catalog) {
        if (this.isDatabaseH2() && Srl.is_NotNull_and_NotTrimmedEmpty((String)catalog)) {
            catalog = catalog.toUpperCase();
        }
        return catalog;
    }

    public UnifiedSchema getDatabaseSchema() {
        if (this._mainSchema != null) {
            return this._mainSchema;
        }
        String schema = this._databaseInfo.getDatabaseSchema();
        schema = this.filterDatabaseSchema(schema);
        this._mainSchema = this.createAsMainSchema(this.getDatabaseCatalog(), schema);
        return this._mainSchema;
    }

    protected String filterDatabaseSchema(String schema) {
        if (this.isDatabasePostgreSQL()) {
            if (Srl.is_Null_or_TrimmedEmpty((String)schema)) {
                schema = "public";
            }
        } else if (this.isDatabaseOracle()) {
            if (Srl.is_NotNull_and_NotTrimmedEmpty((String)schema)) {
                schema = schema.toUpperCase();
            }
        } else if (this.isDatabaseDB2()) {
            if (Srl.is_NotNull_and_NotTrimmedEmpty((String)schema)) {
                schema = schema.toUpperCase();
            }
        } else if (this.isDatabaseH2()) {
            if (Srl.is_Null_or_TrimmedEmpty((String)schema)) {
                schema = "PUBLIC";
            }
        } else if (this.isDatabaseDerby() && Srl.is_NotNull_and_NotTrimmedEmpty((String)schema)) {
            schema = schema.toUpperCase();
        }
        return schema;
    }

    protected UnifiedSchema createAsMainSchema(String catalog, String schema) {
        return UnifiedSchema.createAsMainSchema(catalog, schema);
    }

    public String getDatabaseUser() {
        return this._databaseInfo.getDatabaseUser();
    }

    public String getDatabasePassword() {
        return this._databaseInfo.getDatabasePassword();
    }

    public boolean isDifferentUserSchema() {
        UnifiedSchema databaseSchema;
        String databaseUser = this.getDatabaseUser();
        return !databaseUser.equalsIgnoreCase((databaseSchema = this.getDatabaseSchema()).getPureSchema());
    }

    public List<UnifiedSchema> getTargetSchemaList() {
        ArrayList<UnifiedSchema> targetSchemaList = new ArrayList<UnifiedSchema>();
        UnifiedSchema mainSchema = this.getDatabaseSchema();
        targetSchemaList.add(mainSchema);
        targetSchemaList.addAll(this.getAdditionalSchemaList());
        return targetSchemaList;
    }

    public Properties getDatabaseConnectionProperties() {
        if (this._databaseConnectionProperties != null) {
            return this._databaseConnectionProperties;
        }
        this._databaseConnectionProperties = this._databaseInfo.getDatabaseConnectionProperties();
        return this._databaseConnectionProperties;
    }

    public List<String> getObjectTypeTargetList() {
        return this.getVairousStringList("objectTypeTargetList", this.getDatabaseTypeList());
    }

    public boolean hasObjectTypeSynonym() {
        return DfConnectionProperties.hasObjectTypeSynonym(this.getObjectTypeTargetList());
    }

    protected List<String> getDatabaseTypeList() {
        ArrayList<Object> defaultList = new ArrayList<Object>();
        defaultList.add("TABLE");
        defaultList.add("VIEW");
        ArrayList<String> resultList = new ArrayList<String>();
        List<Object> listProp = this.listProp("torque.database.type.list", defaultList);
        for (Object object : listProp) {
            resultList.add((String)object);
        }
        return resultList;
    }

    public List<String> getTableExceptList() {
        List<String> vairousList = this.getVairousStringList("tableExceptList");
        if (!vairousList.isEmpty()) {
            return vairousList;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        List<Object> listProp = this.listProp("torque.table.except.list", DEFAULT_EMPTY_LIST);
        for (Object object : listProp) {
            resultList.add((String)object);
        }
        return resultList;
    }

    public List<String> getTableTargetList() {
        List<String> vairousList = this.getVairousStringList("tableTargetList");
        if (!vairousList.isEmpty()) {
            return vairousList;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        List<Object> listProp = this.listProp("torque.table.target.list", DEFAULT_EMPTY_LIST);
        for (Object object : listProp) {
            resultList.add((String)object);
        }
        return resultList;
    }

    public Map<String, List<String>> getColumnExceptMap() {
        if (this._columnExceptMap != null) {
            return this._columnExceptMap;
        }
        List<String> oldStyleList = this.getVairousStringList("columnExceptList");
        if (!oldStyleList.isEmpty()) {
            String msg = "You should migrate 'columnExceptList' to 'columnExceptMap'";
            msg = msg + " in databaseInfoMap.dfprop: columnExceptList=" + oldStyleList;
            throw new IllegalStateException(msg);
        }
        StringKeyMap columnExceptMap = StringKeyMap.createAsFlexible();
        Map<String, Object> keyMap = this.getVairousStringKeyMap("columnExceptMap");
        if (keyMap.isEmpty()) {
            return columnExceptMap;
        }
        Set<Map.Entry<String, Object>> entrySet = keyMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String tableName = entry.getKey();
            Object obj = entry.getValue();
            if (!(obj instanceof List)) {
                String msg = "The type of element in the property 'columnExceptMap' should be List:";
                msg = msg + " type=" + DfTypeUtil.toClassTitle((Object)obj) + " value=" + obj;
                throw new DfIllegalPropertyTypeException(msg);
            }
            List columnList = (List)obj;
            columnExceptMap.put(tableName, columnList);
        }
        this._columnExceptMap = columnExceptMap;
        return this._columnExceptMap;
    }

    protected void assertOldStyleAdditionalSchema() {
        Object oldStyle = this.getVariousObject("additionalSchemaList");
        if (oldStyle != null) {
            String msg = "The property 'additionalSchemaList' have been unsupported!";
            msg = msg + " Please use the property 'additionalSchemaMap'.";
            throw new IllegalStateException(msg);
        }
    }

    protected Map<String, DfAdditionalSchemaInfo> getAdditionalSchemaMap() {
        if (this._additionalSchemaMap != null) {
            return this._additionalSchemaMap;
        }
        this.assertOldStyleAdditionalSchema();
        this._additionalSchemaMap = StringKeyMap.createAsCaseInsensitive();
        Map<String, Object> additionalSchemaMap = this.getVairousStringKeyMap("additionalSchemaMap");
        if (additionalSchemaMap == null) {
            return this._additionalSchemaMap;
        }
        Set<Map.Entry<String, Object>> entrySet = additionalSchemaMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            boolean explicitCatalog;
            String catalog;
            String msg;
            String identifiedSchema = entry.getKey();
            Object obj = entry.getValue();
            if (obj == null) {
                msg = "The value of schema in the property 'additionalSchemaMap' should be required:";
                msg = msg + " identifiedSchema=" + identifiedSchema;
                msg = msg + " additionalSchemaMap=" + additionalSchemaMap;
                throw new DfRequiredPropertyNotFoundException(msg);
            }
            if (!(obj instanceof Map)) {
                msg = "The type of schema value in the property 'additionalSchemaMap' should be Map:";
                msg = msg + " type=" + DfTypeUtil.toClassTitle((Object)obj) + " value=" + obj;
                throw new DfIllegalPropertyTypeException(msg);
            }
            Map elementMap = (Map)obj;
            DfAdditionalSchemaInfo info = new DfAdditionalSchemaInfo();
            if (identifiedSchema.contains(".")) {
                catalog = Srl.substringFirstFront((String)identifiedSchema, (String[])new String[]{"."});
                explicitCatalog = true;
            } else {
                catalog = this.getDatabaseCatalog();
                explicitCatalog = false;
            }
            String schema = this.filterDatabaseSchema(Srl.substringFirstRear((String)identifiedSchema, (String[])new String[]{"."}));
            UnifiedSchema unifiedSchema = this.createAsAdditionalSchema(catalog, schema, explicitCatalog);
            info.setUnifiedSchema(unifiedSchema);
            this.setupAdditionalSchemaObjectTypeTargetList(info, elementMap);
            this.setupAdditionalSchemaTableExceptList(info, elementMap);
            this.setupAdditionalSchemaTableTargetList(info, elementMap);
            this.setupAdditionalSchemaColumnExceptList(info, elementMap);
            info.setSuppressCommonColumn(this.isProperty("isSuppressCommonColumn", false, elementMap));
            info.setSuppressProcedure(this.isProperty("isSuppressProcedure", false, elementMap));
            this._additionalSchemaMap.put(unifiedSchema.getIdentifiedSchema(), info);
        }
        return this._additionalSchemaMap;
    }

    protected UnifiedSchema createAsAdditionalSchema(String catalog, String schema, boolean explicitCatalog) {
        return UnifiedSchema.createAsAdditionalSchema(catalog, schema, explicitCatalog);
    }

    protected void setupAdditionalSchemaObjectTypeTargetList(DfAdditionalSchemaInfo info, Map<String, Object> elementMap) {
        Object obj = elementMap.get("objectTypeTargetList");
        if (obj == null) {
            List objectTypeTargetList = Collections.EMPTY_LIST;
            info.setObjectTypeTargetList(objectTypeTargetList);
        } else {
            if (!(obj instanceof List)) {
                String msg = "The type of objectTypeTargetList in the property 'additionalSchemaMap' should be List:";
                msg = msg + " type=" + DfTypeUtil.toClassTitle((Object)obj) + " value=" + obj;
                throw new DfIllegalPropertyTypeException(msg);
            }
            List objectTypeTargetList = (List)obj;
            info.setObjectTypeTargetList(objectTypeTargetList);
        }
    }

    protected void setupAdditionalSchemaTableExceptList(DfAdditionalSchemaInfo info, Map<String, Object> elementMap) {
        Object obj = elementMap.get("tableExceptList");
        if (obj == null) {
            List tableExceptList = DfCollectionUtil.emptyList();
            info.setTableExceptList(tableExceptList);
        } else {
            if (!(obj instanceof List)) {
                String msg = "The type of tableExceptList in the property 'additionalSchemaMap' should be List:";
                msg = msg + " type=" + DfTypeUtil.toClassTitle((Object)obj) + " value=" + obj;
                throw new DfIllegalPropertyTypeException(msg);
            }
            List tableExceptList = (List)obj;
            info.setTableExceptList(tableExceptList);
        }
    }

    protected void setupAdditionalSchemaTableTargetList(DfAdditionalSchemaInfo info, Map<String, Object> elementMap) {
        Object obj = elementMap.get("tableTargetList");
        if (obj == null) {
            List tableTargetList = DfCollectionUtil.emptyList();
            info.setTableTargetList(tableTargetList);
        } else {
            if (!(obj instanceof List)) {
                String msg = "The type of tableTargetList in the property 'additionalSchemaMap' should be List:";
                msg = msg + " type=" + DfTypeUtil.toClassTitle((Object)obj) + " value=" + obj;
                throw new DfIllegalPropertyTypeException(msg);
            }
            List tableTargetList = (List)obj;
            info.setTableTargetList(tableTargetList);
        }
    }

    protected void setupAdditionalSchemaColumnExceptList(DfAdditionalSchemaInfo info, Map<String, Object> elementMap) {
        Object obj = elementMap.get("columnExceptMap");
        if (obj == null) {
            Map columnExceptMap = DfCollectionUtil.emptyMap();
            info.setColumnExceptMap(columnExceptMap);
        } else {
            if (!(obj instanceof Map)) {
                String msg = "The type of columnExceptMap in the property 'additionalSchemaMap' should be Map:";
                msg = msg + " type=" + DfTypeUtil.toClassTitle((Object)obj) + " value=" + obj;
                throw new DfIllegalPropertyTypeException(msg);
            }
            Map columnExceptMap = (Map)obj;
            StringKeyMap flexibleMap = StringKeyMap.createAsFlexible();
            flexibleMap.putAll(columnExceptMap);
            info.setColumnExceptMap((Map<String, List<String>>)flexibleMap);
        }
    }

    public List<UnifiedSchema> getAdditionalSchemaList() {
        Map<String, DfAdditionalSchemaInfo> schemaMap = this.getAdditionalSchemaMap();
        Set<Map.Entry<String, DfAdditionalSchemaInfo>> entrySet = schemaMap.entrySet();
        ArrayList<UnifiedSchema> schemaList = new ArrayList<UnifiedSchema>();
        for (Map.Entry<String, DfAdditionalSchemaInfo> entry : entrySet) {
            DfAdditionalSchemaInfo info = entry.getValue();
            UnifiedSchema unifiedSchema = info.getUnifiedSchema();
            schemaList.add(unifiedSchema);
        }
        return schemaList;
    }

    public boolean hasAdditionalSchema() {
        return !this.getAdditionalSchemaMap().isEmpty();
    }

    public boolean hasCatalogAdditionalSchema() {
        List<UnifiedSchema> additionalSchemaList = this.getAdditionalSchemaList();
        for (UnifiedSchema unifiedSchema : additionalSchemaList) {
            if (!unifiedSchema.isCatalogAdditionalSchema()) continue;
            return true;
        }
        return false;
    }

    public DfAdditionalSchemaInfo getAdditionalSchemaInfo(UnifiedSchema unifiedSchema) {
        if (unifiedSchema == null) {
            return null;
        }
        Map<String, DfAdditionalSchemaInfo> map = this.getAdditionalSchemaMap();
        String identifiedSchema = unifiedSchema.getIdentifiedSchema();
        return map.get(identifiedSchema);
    }

    protected List<String> getVairousStringList(String key) {
        return this.getVairousStringList(key, Collections.EMPTY_LIST);
    }

    protected List<String> getVairousStringList(String key, List<String> defaultList) {
        Object value = this.getVariousObject(key);
        if (value == null) {
            return defaultList != null ? defaultList : Collections.EMPTY_LIST;
        }
        this.assertVariousPropertyList(key, value);
        return (List)value;
    }

    protected void assertVariousPropertyList(String name, Object value) {
        if (!(value instanceof List)) {
            String msg = "The property '" + name + "' should be List: " + value;
            throw new IllegalStateException(msg);
        }
    }

    protected Map<String, Object> getVairousStringKeyMap(String key) {
        return this.getVairousStringKeyMap(key, Collections.EMPTY_MAP);
    }

    protected Map<String, Object> getVairousStringKeyMap(String key, Map<String, Object> defaultMap) {
        Object value = this.getVariousObject(key);
        if (value == null) {
            return defaultMap != null ? defaultMap : Collections.EMPTY_MAP;
        }
        this.assertVariousPropertyMap(key, value);
        return (Map)value;
    }

    protected void assertVariousPropertyMap(String name, Object value) {
        if (!(value instanceof Map)) {
            String msg = "The property '" + name + "' should be Map: " + value;
            throw new IllegalStateException(msg);
        }
    }

    protected Object getVariousObject(String key) {
        Map<String, Object> variousMap = this._databaseInfo.getDatabaseVariousMap();
        return variousMap.get(key);
    }

    public boolean isDatabaseMySQL() {
        return this.getBasicProperties().isDatabaseMySQL();
    }

    public boolean isDatabasePostgreSQL() {
        return this.getBasicProperties().isDatabasePostgreSQL();
    }

    public boolean isDatabaseOracle() {
        return this.getBasicProperties().isDatabaseOracle();
    }

    public boolean isDatabaseDB2() {
        return this.getBasicProperties().isDatabaseDB2();
    }

    public boolean isDatabaseSQLServer() {
        return this.getBasicProperties().isDatabaseSQLServer();
    }

    public boolean isDatabaseH2() {
        return this.getBasicProperties().isDatabaseH2();
    }

    public boolean isDatabaseDerby() {
        return this.getBasicProperties().isDatabaseDerby();
    }

    public boolean isDatabaseSQLite() {
        return this.getBasicProperties().isDatabaseSQLite();
    }

    public boolean isDatabaseMSAccess() {
        return this.getBasicProperties().isDatabaseMSAccess();
    }

    public Connection createMainSchemaConnection() {
        String driver = this.getDatabaseDriver();
        String url = this.getDatabaseUrl();
        UnifiedSchema schema = this.getDatabaseSchema();
        String user = this.getDatabaseUser();
        String password = this.getDatabasePassword();
        _log.info((Object)"...Creating a connection to main schema");
        return this.createConnection(driver, url, schema, user, password);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DatabaseInfo {
        private static final String KEY_DRIVER = "driver";
        private static final String KEY_URL = "url";
        private static final String KEY_CATALOG = "catalog";
        private static final String KEY_SCHEMA = "schema";
        private static final String KEY_USER = "user";
        private static final String KEY_PASSWORD = "password";
        private static final String KEY_PROPERTIES_MAP = "propertiesMap";
        private static final String KEY_VARIOUS_MAP = "variousMap";
        protected Map<String, Object> _databaseInfoMap;

        public String getDatabaseDriver() {
            this.initializeDatabaseInfoMap();
            String key = KEY_DRIVER;
            String databaseInfoElement = this.getDatabaseInfoElement(KEY_DRIVER);
            if (databaseInfoElement != null) {
                return databaseInfoElement;
            }
            return DfDatabaseProperties.this.stringProp("torque.database.driver");
        }

        public String getDatabaseUrl() {
            this.initializeDatabaseInfoMap();
            String key = KEY_URL;
            String databaseInfoElement = this.getDatabaseInfoElement(KEY_URL);
            if (databaseInfoElement != null) {
                return databaseInfoElement + this.getDatabaseUriProperty();
            }
            return DfDatabaseProperties.this.stringProp("torque.database.url");
        }

        private String getDatabaseUriProperty() {
            this.initializeDatabaseInfoMap();
            StringBuilder sb = new StringBuilder();
            Set<String> keySet = this._databaseInfoMap.keySet();
            for (String key : keySet) {
                if (this.equalsKeys(key, KEY_DRIVER, KEY_URL, KEY_CATALOG, KEY_SCHEMA, KEY_USER, KEY_PASSWORD, KEY_PROPERTIES_MAP, KEY_VARIOUS_MAP)) continue;
                Object value = this._databaseInfoMap.get(key);
                sb.append(";").append(key).append("=").append(value);
            }
            return sb.toString();
        }

        private boolean equalsKeys(String target, String ... keys) {
            for (String key : keys) {
                if (!target.equals(key)) continue;
                return true;
            }
            return false;
        }

        public String getDatabaseCatalog() {
            this.initializeDatabaseInfoMap();
            String key = KEY_CATALOG;
            String databaseInfoElement = this.getDatabaseInfoElement(KEY_CATALOG);
            if (databaseInfoElement != null) {
                return databaseInfoElement;
            }
            return DfDatabaseProperties.this.stringProp("torque.database.catalog", "");
        }

        public String getDatabaseSchema() {
            this.initializeDatabaseInfoMap();
            String key = KEY_SCHEMA;
            String databaseInfoElement = this.getDatabaseInfoElement(KEY_SCHEMA);
            if (databaseInfoElement != null) {
                return databaseInfoElement;
            }
            return DfDatabaseProperties.this.stringProp("torque.database.schema", "");
        }

        public String getDatabaseUser() {
            this.initializeDatabaseInfoMap();
            String key = KEY_USER;
            String databaseInfoElement = this.getDatabaseInfoElement(KEY_USER);
            if (databaseInfoElement != null) {
                return databaseInfoElement;
            }
            return DfDatabaseProperties.this.stringProp("torque.database.user");
        }

        public String getDatabasePassword() {
            this.initializeDatabaseInfoMap();
            String key = KEY_PASSWORD;
            String databaseInfoElement = this.getDatabaseInfoElement(KEY_PASSWORD);
            if (databaseInfoElement != null) {
                return databaseInfoElement;
            }
            return DfDatabaseProperties.this.stringProp("torque.database.password");
        }

        public Properties getDatabaseConnectionProperties() {
            this.initializeDatabaseInfoMap();
            String key = KEY_PROPERTIES_MAP;
            Map<String, String> propertiesMap = this.getDatabaseInfoElementAsPropertiesMap(KEY_PROPERTIES_MAP);
            Properties props = new Properties();
            if (propertiesMap.isEmpty()) {
                return props;
            }
            Set<String> keySet = propertiesMap.keySet();
            for (String propKey : keySet) {
                String propValue = propertiesMap.get(propKey);
                props.setProperty(propKey, propValue);
            }
            return props;
        }

        public Map<String, Object> getDatabaseVariousMap() {
            this.initializeDatabaseInfoMap();
            String key = KEY_VARIOUS_MAP;
            Map<String, Object> variousMap = this.getDatabaseInfoElementAsVariousMap(KEY_VARIOUS_MAP);
            return variousMap;
        }

        protected void initializeDatabaseInfoMap() {
            if (this._databaseInfoMap == null) {
                Map<String, Object> databaseInfoMap = DfDatabaseProperties.this.getOutsidePropMap("databaseInfo");
                if (databaseInfoMap.isEmpty()) {
                    databaseInfoMap = DfDatabaseProperties.this.getOutsidePropMap("databaseInfoMap");
                }
                if (!databaseInfoMap.isEmpty()) {
                    this._databaseInfoMap = databaseInfoMap;
                }
            }
        }

        protected boolean hasDatabaseInfoMap() {
            return this._databaseInfoMap != null;
        }

        protected String getDatabaseInfoElement(String key) {
            if (this._databaseInfoMap != null) {
                if (!this._databaseInfoMap.containsKey(key)) {
                    return "";
                }
                String value = (String)this._databaseInfoMap.get(key);
                return value != null ? value : "";
            }
            return null;
        }

        protected Map<String, String> getDatabaseInfoElementAsPropertiesMap(String key) {
            if (this._databaseInfoMap != null) {
                if (!this._databaseInfoMap.containsKey(key)) {
                    return new LinkedHashMap<String, String>();
                }
                Map valueList = (Map)this._databaseInfoMap.get(key);
                return valueList != null ? valueList : new LinkedHashMap();
            }
            return null;
        }

        protected Map<String, Object> getDatabaseInfoElementAsVariousMap(String key) {
            if (this._databaseInfoMap != null) {
                if (!this._databaseInfoMap.containsKey(key)) {
                    return new LinkedHashMap<String, Object>();
                }
                Map valueList = (Map)this._databaseInfoMap.get(key);
                return valueList != null ? valueList : new LinkedHashMap();
            }
            return null;
        }
    }
}

